/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulUnsignedLongsEvaluator;

public class Mul
extends EsqlArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Mul", Mul::new);

    @FunctionInfo(operator="*", returnType={"double", "integer", "long", "unsigned_long"}, description="Multiply two numbers together. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.")
    public Mul(Source source, @Param(name="lhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression left, @Param(name="rhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MUL, MulIntsEvaluator.Factory::new, MulLongsEvaluator.Factory::new, MulUnsignedLongsEvaluator.Factory::new, MulDoublesEvaluator.Factory::new);
    }

    private Mul(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.MUL, MulIntsEvaluator.Factory::new, MulLongsEvaluator.Factory::new, MulUnsignedLongsEvaluator.Factory::new, MulDoublesEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Mul.ENTRY.name;
    }

    @Override
    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Div::new;
    }

    @Override
    protected boolean isCommutative() {
        return true;
    }

    @Override
    public Mul swapLeftAndRight() {
        return new Mul(this.source(), this.right(), this.left());
    }

    @Override
    protected NodeInfo<Mul> info() {
        return NodeInfo.create(this, Mul::new, this.left(), this.right());
    }

    @Override
    protected Mul replaceChildren(Expression left, Expression right) {
        return new Mul(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongMultiplyExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return NumericUtils.asFiniteNumber((double)(lhs * rhs));
    }
}

