/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Div
extends EsqlArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Div", Div::new);
    private DataType type;

    @FunctionInfo(operator="/", returnType={"double", "integer", "long", "unsigned_long"}, description="Divide one number by another. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.", note="Division of two integer types will yield an integer result, rounding towards 0. If you need floating point division, <<esql-cast-operator>> one of the arguments to a `DOUBLE`.")
    public Div(Source source, @Param(name="lhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression left, @Param(name="rhs", description="A numeric value.", type={"double", "integer", "long", "unsigned_long"}) Expression right) {
        this(source, left, right, (DataType)null);
    }

    public Div(Source source, Expression left, Expression right, DataType type) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.DIV, DivIntsEvaluator.Factory::new, DivLongsEvaluator.Factory::new, DivUnsignedLongsEvaluator.Factory::new, DivDoublesEvaluator.Factory::new);
        this.type = type;
    }

    private Div(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.DIV, DivIntsEvaluator.Factory::new, DivLongsEvaluator.Factory::new, DivUnsignedLongsEvaluator.Factory::new, DivDoublesEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Div.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        if (this.type == null) {
            this.type = super.dataType();
        }
        return this.type;
    }

    @Override
    protected NodeInfo<Div> info() {
        return NodeInfo.create(this, Div::new, this.left(), this.right(), this.type);
    }

    @Override
    protected Div replaceChildren(Expression newLeft, Expression newRight) {
        return new Div(this.source(), newLeft, newRight, this.type);
    }

    @Override
    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Mul::new;
    }

    static int processInts(int lhs, int rhs) {
        if (rhs == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs / rhs;
    }

    static long processLongs(long lhs, long rhs) {
        if (rhs == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs / rhs;
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        if (rhs == NumericUtils.ZERO_AS_UNSIGNED_LONG) {
            throw new ArithmeticException("/ by zero");
        }
        return EsqlDataTypeConverter.longToUnsignedLong(Long.divideUnsigned(EsqlDataTypeConverter.longToUnsignedLong(lhs, true), EsqlDataTypeConverter.longToUnsignedLong(rhs, true)), true);
    }

    static double processDoubles(double lhs, double rhs) {
        double value = lhs / rhs;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new ArithmeticException("/ by zero");
        }
        return value;
    }
}

