/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddDateNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddDatetimesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.AddUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;

public class Add
extends DateTimeArithmeticOperation
implements BinaryComparisonInversible {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Add", Add::new);

    @FunctionInfo(operator="+", returnType={"double", "integer", "long", "date_nanos", "date_period", "datetime", "time_duration", "unsigned_long"}, description="Add two numbers together. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.")
    public Add(Source source, @Param(name="lhs", description="A numeric value or a date time value.", type={"double", "integer", "long", "date_nanos", "date_period", "datetime", "time_duration", "unsigned_long"}) Expression left, @Param(name="rhs", description="A numeric value or a date time value.", type={"double", "integer", "long", "date_nanos", "date_period", "datetime", "time_duration", "unsigned_long"}) Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.ADD, AddIntsEvaluator.Factory::new, AddLongsEvaluator.Factory::new, AddUnsignedLongsEvaluator.Factory::new, AddDoublesEvaluator.Factory::new, AddDatetimesEvaluator.Factory::new, AddDateNanosEvaluator.Factory::new);
    }

    private Add(StreamInput in) throws IOException {
        super(in, EsqlArithmeticOperation.OperationSymbol.ADD, AddIntsEvaluator.Factory::new, AddLongsEvaluator.Factory::new, AddUnsignedLongsEvaluator.Factory::new, AddDoublesEvaluator.Factory::new, AddDatetimesEvaluator.Factory::new, AddDateNanosEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return Add.ENTRY.name;
    }

    @Override
    protected NodeInfo<Add> info() {
        return NodeInfo.create(this, Add::new, this.left(), this.right());
    }

    @Override
    protected Add replaceChildren(Expression left, Expression right) {
        return new Add(this.source(), left, right);
    }

    @Override
    public Add swapLeftAndRight() {
        return new Add(this.source(), this.right(), this.left());
    }

    @Override
    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Sub::new;
    }

    @Override
    protected boolean isCommutative() {
        return true;
    }

    static int processInts(int lhs, int rhs) {
        return Math.addExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.addExact(lhs, rhs);
    }

    public static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongAddExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return NumericUtils.asFiniteNumber((double)(lhs + rhs));
    }

    static long processDatetimes(long datetime, TemporalAmount temporalAmount) {
        return org.elasticsearch.xpack.esql.core.util.DateUtils.asMillis(org.elasticsearch.xpack.esql.core.util.DateUtils.asDateTime(datetime).plus(temporalAmount));
    }

    static long processDateNanos(long dateNanos, TemporalAmount temporalAmount) {
        try {
            return DateUtils.toLong((Instant)Instant.from(ZonedDateTime.ofInstant(DateUtils.toInstant((long)dateNanos), org.elasticsearch.xpack.esql.core.util.DateUtils.UTC).plus(temporalAmount)));
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeException("Date nanos out of range.  Must be between 1970-01-01T00:00:00Z and 2262-04-11T23:47:16.854775807");
        }
    }

    @Override
    public Period fold(Period left, Period right) {
        return left.plus(right);
    }

    @Override
    public Duration fold(Duration left, Duration right) {
        return left.plus(right);
    }
}

