/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.expression.predicate.fulltext.FullTextUtils;

public abstract class FullTextPredicate
extends Expression {
    private final String query;
    private final String options;
    private final Map<String, String> optionMap;
    private final String analyzer;

    FullTextPredicate(Source source, String query, @Nullable String options, List<Expression> children) {
        super(source, children);
        this.query = query;
        this.options = options;
        this.optionMap = FullTextUtils.parseSettings(options, source);
        this.analyzer = this.optionMap.get("analyzer");
    }

    protected FullTextPredicate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readString(), in.readOptionalString(), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public String query() {
        return this.query;
    }

    public String options() {
        return this.options;
    }

    public Map<String, String> optionMap() {
        return this.optionMap;
    }

    public String analyzer() {
        return this.analyzer;
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeString(this.query);
        out.writeOptionalString(this.options);
        out.writeNamedWriteableCollection(this.children());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FullTextPredicate other = (FullTextPredicate)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.options, other.options);
    }

    public static enum Operator {
        AND,
        OR;


        public org.elasticsearch.index.query.Operator toEs() {
            return org.elasticsearch.index.query.Operator.fromString((String)this.name());
        }
    }
}

