/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.util;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;

public final class UrlCodecUtils {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    private UrlCodecUtils() {
    }

    public static BytesRef urlEncode(BytesRef val, BreakingBytesRefBuilder scratch, boolean plusForSpace) {
        int size = UrlCodecUtils.computeSizeAfterEncoding(val, plusForSpace);
        if (size == -1) {
            return val;
        }
        scratch.grow(size);
        scratch.clear();
        int lo = val.offset;
        int hi = val.offset + val.length;
        for (int i = lo; i < hi; ++i) {
            byte b = val.bytes[i];
            char c = (char)(b & 0xFF);
            if (plusForSpace && c == ' ') {
                scratch.append((byte)43);
                continue;
            }
            if (UrlCodecUtils.isRfc3986Safe(c)) {
                scratch.append(b);
                continue;
            }
            scratch.append((byte)37);
            scratch.append((byte)HEX_DIGITS[c >> 4 & 0xF]);
            scratch.append((byte)HEX_DIGITS[c & 0xF]);
        }
        return scratch.bytesRefView();
    }

    public static boolean isRfc3986Safe(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }

    private static int computeSizeAfterEncoding(BytesRef val, boolean plusForSpace) {
        int size = 0;
        boolean noEncodingNeeded = true;
        int lo = val.offset;
        int hi = val.offset + val.length;
        for (int i = lo; i < hi; ++i) {
            char c = (char)(val.bytes[i] & 0xFF);
            if (plusForSpace && c == ' ') {
                ++size;
                noEncodingNeeded = false;
                continue;
            }
            if (UrlCodecUtils.isRfc3986Safe(c)) {
                ++size;
                continue;
            }
            size += 3;
            noEncodingNeeded = false;
        }
        if (noEncodingNeeded) {
            return -1;
        }
        return size;
    }
}

