/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.util;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.ChunkerBuilder;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static List<String> chunkText(String content, ChunkingSettings chunkingSettings) {
        Chunker chunker = ChunkerBuilder.fromChunkingStrategy((ChunkingStrategy)chunkingSettings.getChunkingStrategy());
        return chunker.chunk(content, chunkingSettings).stream().map(offset -> content.substring(offset.start(), offset.end())).toList();
    }

    public static void emitChunks(BytesRefBlock.Builder builder, List<String> chunks) {
        int size = chunks.size();
        if (size == 0) {
            builder.appendNull();
        } else if (size == 1) {
            builder.appendBytesRef(new BytesRef((CharSequence)chunks.get(0).trim()));
        } else {
            builder.beginPositionEntry();
            for (String chunk : chunks) {
                builder.appendBytesRef(new BytesRef((CharSequence)chunk.trim()));
            }
            builder.endPositionEntry();
        }
    }
}

