/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string.regex;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePatternList;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RegexMatch;
import org.elasticsearch.xpack.esql.io.stream.ExpressionQuery;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class RLikeList
extends RegexMatch<RLikePatternList> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "RLikeList", RLikeList::new);
    Supplier<Automaton> automatonSupplier = new Supplier<Automaton>(){
        Automaton cached;

        @Override
        public Automaton get() {
            if (this.cached == null) {
                this.cached = ((RLikePatternList)RLikeList.this.pattern()).createAutomaton(RLikeList.this.caseInsensitive());
            }
            return this.cached;
        }
    };
    Supplier<CharacterRunAutomaton> characterRunAutomatonSupplier = new Supplier<CharacterRunAutomaton>(){
        CharacterRunAutomaton cached;

        @Override
        public CharacterRunAutomaton get() {
            if (this.cached == null) {
                this.cached = new CharacterRunAutomaton(RLikeList.this.automatonSupplier.get());
            }
            return this.cached;
        }
    };

    public RLikeList(Source source, @Param(name="str", type={"keyword", "text"}, description="A literal value.") Expression value, @Param(name="patterns", type={"keyword", "text"}, description="A list of regular expressions.") RLikePatternList patterns) {
        this(source, value, patterns, false);
    }

    public RLikeList(Source source, Expression field, RLikePatternList rLikePattern, boolean caseInsensitive) {
        super(source, field, rLikePattern, caseInsensitive);
    }

    private RLikeList(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), new RLikePatternList(in), RLikeList.deserializeCaseInsensitivity(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        ((RLikePatternList)this.pattern()).writeTo(out);
        this.serializeCaseInsensitivity(out);
    }

    @Override
    public String name() {
        return RLikeList.ENTRY.name;
    }

    public String getWriteableName() {
        return RLikeList.ENTRY.name;
    }

    @Override
    protected RLikeList replaceChild(Expression newChild) {
        return new RLikeList(this.source(), newChild, (RLikePatternList)this.pattern(), this.caseInsensitive());
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableAttribute(this.field()) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public org.elasticsearch.xpack.esql.core.querydsl.query.Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        Expression expression;
        Expression field = this.field();
        LucenePushdownPredicates.checkIsPushableAttribute(field);
        if (field instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)field;
            expression = fa.exactAttribute();
        } else {
            expression = field;
        }
        return this.translateField(handler.nameOf(expression));
    }

    private org.elasticsearch.xpack.esql.core.querydsl.query.Query translateField(String targetFieldName) {
        return new ExpressionQuery(this.source(), targetFieldName, this);
    }

    @Override
    public Query asLuceneQuery(MappedFieldType fieldType, MultiTermQuery.RewriteMethod constantScoreRewrite, SearchExecutionContext context) {
        return fieldType.automatonQuery(this.automatonSupplier, this.characterRunAutomatonSupplier, constantScoreRewrite, context, this.getLuceneQueryDescription());
    }

    @Override
    public Expression optimizeStringCasingWithInsensitiveRegexMatch(Expression unwrappedField, Predicate<String> matchesCaseFn) {
        List<RLikePattern> filtered = ((RLikePatternList)this.pattern()).patternList().stream().filter(p -> matchesCaseFn.test(p.pattern())).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return Literal.of(this, Boolean.FALSE);
        }
        return new RLikeList(this.source(), unwrappedField, new RLikePatternList(filtered), true);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, RLikeList::new, this.field(), (RLikePatternList)this.pattern(), this.caseInsensitive());
    }

    private String getLuceneQueryDescription() {
        String patternDesc = ((RLikePatternList)this.pattern()).patternList().stream().map(RLikePattern::pattern).collect(Collectors.joining("\", \""));
        return "RLIKE(\"" + patternDesc + "\"), caseInsensitive=" + this.caseInsensitive();
    }
}

