/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.xpack.core.common.chunks.MemoryIndexChunkScorer;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.TopSnippets;

public final class TopSnippetsBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TopSnippetsBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator query;
    private final ChunkingSettings chunkingSettings;
    private final MemoryIndexChunkScorer scorer;
    private final int numSnippets;
    private final DriverContext driverContext;
    private Warnings warnings;

    public TopSnippetsBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator query, ChunkingSettings chunkingSettings, MemoryIndexChunkScorer scorer, int numSnippets, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.query = query;
        this.chunkingSettings = chunkingSettings;
        this.scorer = scorer;
        this.numSnippets = numSnippets;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector queryVector;
                BytesRefVector strVector;
                BytesRefBlock queryBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                queryBlock = (BytesRefBlock)this.query.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, queryBlock);
                                    if (queryBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (queryBlock != null) {
                                        try {
                                            queryBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                queryBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        queryVector = queryBlock.asVector();
                        if (queryVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, queryBlock);
                        if (queryBlock == null) break block19;
                        queryBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, queryVector);
                if (queryBlock == null) break block20;
                queryBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        return baseRamBytesUsed += this.query.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock queryBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef queryScratch = new BytesRef();
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (strBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (queryBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                BytesRef query = queryBlock.getBytesRef(queryBlock.getFirstValueIndex(p), queryScratch);
                TopSnippets.process(result, str, query, this.chunkingSettings, this.scorer, this.numSnippets);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, BytesRefVector queryVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef queryScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                BytesRef query = queryVector.getBytesRef(p, queryScratch);
                TopSnippets.process(result, str, query, this.chunkingSettings, this.scorer, this.numSnippets);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "TopSnippetsBytesRefEvaluator[str=" + String.valueOf(this.str) + ", query=" + String.valueOf(this.query) + ", chunkingSettings=" + String.valueOf(this.chunkingSettings) + ", scorer=" + String.valueOf(this.scorer) + ", numSnippets=" + this.numSnippets + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.query});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory query;
        private final ChunkingSettings chunkingSettings;
        private final MemoryIndexChunkScorer scorer;
        private final int numSnippets;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory query, ChunkingSettings chunkingSettings, MemoryIndexChunkScorer scorer, int numSnippets) {
            this.source = source;
            this.str = str;
            this.query = query;
            this.chunkingSettings = chunkingSettings;
            this.scorer = scorer;
            this.numSnippets = numSnippets;
        }

        public TopSnippetsBytesRefEvaluator get(DriverContext context) {
            return new TopSnippetsBytesRefEvaluator(this.source, this.str.get(context), this.query.get(context), this.chunkingSettings, this.scorer, this.numSnippets, context);
        }

        public String toString() {
            return "TopSnippetsBytesRefEvaluator[str=" + String.valueOf(this.str) + ", query=" + String.valueOf(this.query) + ", chunkingSettings=" + String.valueOf(this.chunkingSettings) + ", scorer=" + String.valueOf(this.scorer) + ", numSnippets=" + this.numSnippets + "]";
        }
    }
}

