/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RTrimEvaluator;

public class RTrim
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "RTrim", RTrim::new);

    @FunctionInfo(returnType={"keyword"}, description="Removes trailing whitespaces from a string.", examples={@Example(file="string", tag="rtrim")})
    public RTrim(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str) {
        super(source, str);
    }

    private RTrim(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return RTrim.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new RTrimEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new RTrim(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, RTrim::new, this.field());
    }

    static BytesRef process(BytesRef val) {
        int offset;
        int end = offset = val.offset;
        UnicodeUtil.UTF8CodePoint codePoint = new UnicodeUtil.UTF8CodePoint();
        while (offset < val.offset + val.length) {
            codePoint = UnicodeUtil.codePointAt((byte[])val.bytes, (int)offset, (UnicodeUtil.UTF8CodePoint)codePoint);
            if (!Character.isWhitespace(codePoint.codePoint)) {
                end = offset + codePoint.numBytes;
            }
            offset += codePoint.numBytes;
        }
        return new BytesRef(val.bytes, val.offset, end - val.offset);
    }
}

