/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ContainsEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Contains
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Contains", Contains::new);
    private final Expression str;
    private final Expression substr;

    @FunctionInfo(returnType={"boolean"}, description="Returns a boolean that indicates whether a keyword substring is within another string.\nReturns `null` if either parameter is null.", examples={@Example(file="string", tag="contains")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.2.0")})
    public Contains(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression: input string to check against. If `null`, the function returns `null`.") Expression str, @Param(name="substring", type={"keyword", "text"}, description="String expression: A substring to find in the input string. If `null`, the function returns `null`.") Expression substr) {
        super(source, Arrays.asList(str, substr));
        this.str = str;
        this.substr = substr;
    }

    private Contains(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.substr);
    }

    public String getWriteableName() {
        return Contains.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString(this.str, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString(this.substr, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public boolean foldable() {
        return this.str.foldable() && this.substr.foldable();
    }

    static boolean process(BytesRef str, BytesRef substr) {
        if (str.length < substr.length) {
            return false;
        }
        return str.utf8ToString().contains(substr.utf8ToString());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Contains(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Contains::new, this.str, this.substr);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strExpr = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory substrExpr = toEvaluator.apply(this.substr);
        return new ContainsEvaluator.Factory(this.source(), strExpr, substrExpr);
    }

    Expression str() {
        return this.str;
    }

    Expression substr() {
        return this.substr;
    }
}

