/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlClientException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ConcatEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Concat
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Concat", Concat::new);
    static final long MAX_CONCAT_LENGTH = ByteSizeUnit.MB.toBytes(1L);

    @FunctionInfo(returnType={"keyword"}, description="Concatenates two or more strings.", examples={@Example(file="eval", tag="docsConcat")})
    public Concat(Source source, @Param(name="string1", type={"keyword", "text"}, description="Strings to concatenate.") Expression first, @Param(name="string2", type={"keyword", "text"}, description="Strings to concatenate.") List<? extends Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    private Concat(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return Concat.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = Expression.TypeResolution.TYPE_RESOLVED;
        for (Expression value : this.children()) {
            resolution = TypeResolutions.isString(value, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory[] values = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(toEvaluator::apply).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        return new ConcatEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "concat"), values);
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, BytesRef[] values) {
        scratch.grow(Concat.checkedTotalLength(values));
        scratch.clear();
        for (int i = 0; i < values.length; ++i) {
            scratch.append(values[i]);
        }
        return scratch.bytesRefView();
    }

    private static int checkedTotalLength(BytesRef[] values) {
        int length = 0;
        for (BytesRef v : values) {
            length += v.length;
        }
        if ((long)length > MAX_CONCAT_LENGTH) {
            throw new EsqlClientException("concatenating more than [" + MAX_CONCAT_LENGTH + "] bytes is not supported", new Object[0]);
        }
        return length;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Concat(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Concat::new, (Expression)this.children().get(0), this.children().subList(1, this.children().size()));
    }
}

