/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ByteLengthEvaluator;

public class ByteLength
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ByteLength", ByteLength::new);

    @FunctionInfo(returnType={"integer"}, description="Returns the byte length of a string.", note="All strings are in UTF-8, so a single character can use multiple bytes.", examples={@Example(file="eval", tag="byteLength")})
    public ByteLength(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private ByteLength(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ByteLength.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.childrenResolved() ? TypeResolutions.isString(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT) : new Expression.TypeResolution("Unresolved children");
    }

    static int process(BytesRef val) {
        return val.length;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ByteLength(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ByteLength::new, this.field());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new ByteLengthEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }
}

