/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AutomataMatch;

public final class AutomataMatchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(AutomataMatchEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator input;
    private final ByteRunAutomaton automaton;
    private final String pattern;
    private final DriverContext driverContext;
    private Warnings warnings;

    public AutomataMatchEvaluator(Source source, EvalOperator.ExpressionEvaluator input, ByteRunAutomaton automaton, String pattern, DriverContext driverContext) {
        this.source = source;
        this.input = input;
        this.automaton = automaton;
        this.pattern = pattern;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock inputBlock = (BytesRefBlock)this.input.eval(page);){
            BytesRefVector inputVector = inputBlock.asVector();
            if (inputVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), inputBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), inputVector).asBlock();
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.input.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock inputBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (inputBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                BytesRef input = inputBlock.getBytesRef(inputBlock.getFirstValueIndex(p), inputScratch);
                result.appendBoolean(AutomataMatch.process(input, this.automaton, this.pattern));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector inputVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef input = inputVector.getBytesRef(p, inputScratch);
                result.appendBoolean(p, AutomataMatch.process(input, this.automaton, this.pattern));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "AutomataMatchEvaluator[input=" + String.valueOf(this.input) + ", pattern=" + this.pattern + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.input);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory input;
        private final ByteRunAutomaton automaton;
        private final String pattern;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory input, ByteRunAutomaton automaton, String pattern) {
            this.source = source;
            this.input = input;
            this.automaton = automaton;
            this.pattern = pattern;
        }

        public AutomataMatchEvaluator get(DriverContext context) {
            return new AutomataMatchEvaluator(this.source, this.input.get(context), this.automaton, this.pattern, context);
        }

        public String toString() {
            return "AutomataMatchEvaluator[input=" + String.valueOf(this.input) + ", pattern=" + this.pattern + "]";
        }
    }
}

