/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEnvelopeResults;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYMin;

public final class StYMinFromWKBEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StYMinFromWKBEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator wkbBlock;
    private final SpatialEnvelopeResults<DoubleBlock.Builder> resultsBuilder;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StYMinFromWKBEvaluator(Source source, EvalOperator.ExpressionEvaluator wkbBlock, SpatialEnvelopeResults<DoubleBlock.Builder> resultsBuilder, DriverContext driverContext) {
        this.source = source;
        this.wkbBlock = wkbBlock;
        this.resultsBuilder = resultsBuilder;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock wkbBlockBlock = (BytesRefBlock)this.wkbBlock.eval(page);){
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), wkbBlockBlock);
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.wkbBlock.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, BytesRefBlock wkbBlockBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!wkbBlockBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StYMin.fromWKB(result, p, wkbBlockBlock, this.resultsBuilder);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StYMinFromWKBEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.wkbBlock);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory wkbBlock;
        private final Function<DriverContext, SpatialEnvelopeResults<DoubleBlock.Builder>> resultsBuilder;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory wkbBlock, Function<DriverContext, SpatialEnvelopeResults<DoubleBlock.Builder>> resultsBuilder) {
            this.source = source;
            this.wkbBlock = wkbBlock;
            this.resultsBuilder = resultsBuilder;
        }

        public StYMinFromWKBEvaluator get(DriverContext context) {
            return new StYMinFromWKBEvaluator(this.source, this.wkbBlock.get(context), this.resultsBuilder.apply(context), context);
        }

        public String toString() {
            return "StYMinFromWKBEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + "]";
        }
    }
}

