/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialUnaryDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromCartesianDocValuesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromCartesianWKBEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromGeoDocValuesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromGeoWKBEvaluator;

public class StY
extends SpatialUnaryDocValuesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StY", StY::new);

    @FunctionInfo(returnType={"double"}, description="Extracts the `y` coordinate from the supplied point.\nIf the point is of type `geo_point` this is equivalent to extracting the `latitude` value.", examples={@Example(file="spatial", tag="st_x_y")}, depthOffset=1)
    public StY(Source source, @Param(name="point", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`. If `null`, the function returns `null`.") Expression field) {
        this(source, field, false);
    }

    private StY(Source source, Expression field, boolean spatialDocValues) {
        super(source, field, spatialDocValues);
    }

    private StY(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public SpatialDocValuesFunction withDocValues(boolean useDocValues) {
        return new StY(this.source(), this.spatialField(), useDocValues);
    }

    public String getWriteableName() {
        return StY.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.spatialField(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.spatialDocValues) {
            return switch (this.spatialField().dataType()) {
                case DataType.GEO_POINT -> new StYFromGeoDocValuesEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()));
                case DataType.CARTESIAN_POINT -> new StYFromCartesianDocValuesEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()));
                default -> throw new IllegalArgumentException("Cannot use doc values for type " + String.valueOf((Object)this.spatialField().dataType()));
            };
        }
        return switch (this.spatialField().dataType()) {
            case DataType.GEO_POINT -> new StYFromGeoWKBEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()));
            case DataType.CARTESIAN_POINT -> new StYFromCartesianWKBEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()));
            default -> throw new IllegalArgumentException("ST_X unsupported for type " + String.valueOf((Object)this.spatialField().dataType()));
        };
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public boolean prefersDocValuesExtraction() {
        return false;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new StY(this.source(), newChildren.getFirst());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, StY::new, this.spatialField());
    }

    private static double quantizeFromWKB(SpatialCoordinateTypes coordinateType, BytesRef in) {
        Point point = coordinateType.wkbAsPoint(in);
        long encoded = coordinateType.pointAsLong(point.getX(), point.getY());
        return coordinateType.decodeY(encoded);
    }

    static double fromCartesianWellKnownBinary(BytesRef in) {
        return StY.quantizeFromWKB(SpatialCoordinateTypes.CARTESIAN, in);
    }

    static double fromGeoWellKnownBinary(BytesRef in) {
        return StY.quantizeFromWKB(SpatialCoordinateTypes.GEO, in);
    }

    static double fromCartesianDocValues(long encoded) {
        return SpatialCoordinateTypes.CARTESIAN.decodeY(encoded);
    }

    static double fromGeoDocValues(long encoded) {
        return SpatialCoordinateTypes.GEO.decodeY(encoded);
    }
}

