/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEnvelopeResults;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialUnaryDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMaxFromCartesianDocValuesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMaxFromGeoDocValuesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMaxFromWKBEvaluator;

public class StXMax
extends SpatialUnaryDocValuesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StXMax", StXMax::new);

    @FunctionInfo(returnType={"double"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Extracts the maximum value of the `x` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the maximum `longitude` value.", examples={@Example(file="spatial_shapes", tag="st_x_y_min_max")}, depthOffset=1)
    public StXMax(Source source, @Param(name="point", type={"geo_point", "geo_shape", "cartesian_point", "cartesian_shape"}, description="Expression of type `geo_point`, `geo_shape`, `cartesian_point` or `cartesian_shape`. If `null`, the function returns `null`.") Expression field) {
        this(source, field, false);
    }

    private StXMax(Source source, Expression field, boolean spatialDocValues) {
        super(source, field, spatialDocValues);
    }

    private StXMax(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public SpatialDocValuesFunction withDocValues(boolean useDocValues) {
        return new StXMax(this.source(), this.spatialField(), useDocValues);
    }

    public String getWriteableName() {
        return StXMax.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        SpatialEnvelopeResults.Factory resultsBuilder = DataType.isSpatialGeo(this.spatialField().dataType()) ? new SpatialEnvelopeResults.Factory(SpatialCoordinateTypes.GEO, () -> new SpatialEnvelopeVisitor.GeoPointVisitor(SpatialEnvelopeVisitor.WrapLongitude.WRAP)) : new SpatialEnvelopeResults.Factory(SpatialCoordinateTypes.CARTESIAN, SpatialEnvelopeVisitor.CartesianPointVisitor::new);
        EvalOperator.ExpressionEvaluator.Factory spatial = toEvaluator.apply(this.spatialField());
        if (this.spatialDocValues) {
            if (DataType.isSpatialPoint(this.spatialField().dataType())) {
                return DataType.isSpatialGeo(this.spatialField().dataType()) ? new StXMaxFromGeoDocValuesEvaluator.Factory(this.source(), spatial, resultsBuilder::get) : new StXMaxFromCartesianDocValuesEvaluator.Factory(this.source(), spatial, resultsBuilder::get);
            }
            throw new IllegalArgumentException("Cannot use doc values for type " + String.valueOf((Object)this.spatialField().dataType()));
        }
        return new StXMaxFromWKBEvaluator.Factory(this.source(), spatial, resultsBuilder::get);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new StXMax(this.source(), newChildren.getFirst(), this.spatialDocValues);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, StXMax::new, this.spatialField());
    }

    static void buildEnvelopeResults(DoubleBlock.Builder results, Rectangle rectangle, SpatialCoordinateTypes type) {
        results.appendDouble(type.decodeX(type.pointAsLong(rectangle.getMaxX(), 0.0)));
    }

    static void buildDocValuesEnvelopeResults(DoubleBlock.Builder results, Rectangle rectangle) {
        results.appendDouble(rectangle.getMaxX());
    }

    static void fromWKB(DoubleBlock.Builder results, int p, BytesRefBlock wkbBlock, SpatialEnvelopeResults<DoubleBlock.Builder> resultsBuilder) {
        resultsBuilder.fromWellKnownBinary(results, p, wkbBlock, StXMax::buildEnvelopeResults);
    }

    static void fromCartesianDocValues(DoubleBlock.Builder results, int p, LongBlock encodedBlock, SpatialEnvelopeResults<DoubleBlock.Builder> resultsBuilder) {
        resultsBuilder.fromDocValuesLinear(results, p, encodedBlock, Double.NEGATIVE_INFINITY, (v, e) -> Math.max(v, SpatialCoordinateTypes.CARTESIAN.decodeX(e.longValue())));
    }

    static void fromGeoDocValues(DoubleBlock.Builder results, int p, LongBlock encodedBlock, SpatialEnvelopeResults<DoubleBlock.Builder> resultsBuilder) {
        resultsBuilder.fromDocValues(results, p, encodedBlock, StXMax::buildDocValuesEnvelopeResults);
    }
}

