/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEnvelopeResults;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StEnvelope;

public final class StEnvelopeFromDocValuesEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StEnvelopeFromDocValuesEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator encodedBlock;
    private final SpatialEnvelopeResults<BytesRefBlock.Builder> resultsBuilder;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StEnvelopeFromDocValuesEvaluator(Source source, EvalOperator.ExpressionEvaluator encodedBlock, SpatialEnvelopeResults<BytesRefBlock.Builder> resultsBuilder, DriverContext driverContext) {
        this.source = source;
        this.encodedBlock = encodedBlock;
        this.resultsBuilder = resultsBuilder;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock encodedBlockBlock = (LongBlock)this.encodedBlock.eval(page);){
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), encodedBlockBlock);
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.encodedBlock.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, LongBlock encodedBlockBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!encodedBlockBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StEnvelope.fromDocValues(result, p, encodedBlockBlock, this.resultsBuilder);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "StEnvelopeFromDocValuesEvaluator[encodedBlock=" + String.valueOf(this.encodedBlock) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.encodedBlock);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory encodedBlock;
        private final Function<DriverContext, SpatialEnvelopeResults<BytesRefBlock.Builder>> resultsBuilder;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory encodedBlock, Function<DriverContext, SpatialEnvelopeResults<BytesRefBlock.Builder>> resultsBuilder) {
            this.source = source;
            this.encodedBlock = encodedBlock;
            this.resultsBuilder = resultsBuilder;
        }

        public StEnvelopeFromDocValuesEvaluator get(DriverContext context) {
            return new StEnvelopeFromDocValuesEvaluator(this.source, this.encodedBlock.get(context), this.resultsBuilder.apply(context), context);
        }

        public String toString() {
            return "StEnvelopeFromDocValuesEvaluator[encodedBlock=" + String.valueOf(this.encodedBlock) + "]";
        }
    }
}

