/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEnvelopeResults;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialUnaryDocValuesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StEnvelopeFromDocValuesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StEnvelopeFromWKBEvaluator;

public class StEnvelope
extends SpatialUnaryDocValuesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StEnvelope", StEnvelope::new);
    private static final SpatialEnvelopeResults<BytesRefBlock.Builder> geoResults = new SpatialEnvelopeResults(SpatialCoordinateTypes.GEO, (SpatialEnvelopeVisitor.PointVisitor)new SpatialEnvelopeVisitor.GeoPointVisitor(SpatialEnvelopeVisitor.WrapLongitude.WRAP));
    private static final SpatialEnvelopeResults<BytesRefBlock.Builder> cartesianResults = new SpatialEnvelopeResults(SpatialCoordinateTypes.CARTESIAN, (SpatialEnvelopeVisitor.PointVisitor)new SpatialEnvelopeVisitor.CartesianPointVisitor());
    private DataType dataType;

    @FunctionInfo(returnType={"geo_shape", "cartesian_shape"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Determines the minimum bounding box of the supplied geometry.", examples={@Example(file="spatial_shapes", tag="st_envelope")})
    public StEnvelope(Source source, @Param(name="geometry", type={"geo_point", "geo_shape", "cartesian_point", "cartesian_shape"}, description="Expression of type `geo_point`, `geo_shape`, `cartesian_point` or `cartesian_shape`. If `null`, the function returns `null`.") Expression field) {
        this(source, field, false);
    }

    private StEnvelope(Source source, Expression field, boolean useDocValues) {
        super(source, field, useDocValues);
    }

    private StEnvelope(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public SpatialDocValuesFunction withDocValues(boolean useDocValues) {
        return new StEnvelope(this.source(), this.spatialField(), useDocValues);
    }

    public String getWriteableName() {
        return StEnvelope.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.resolved()) {
            this.dataType = switch (this.spatialField().dataType()) {
                case DataType.GEO_POINT, DataType.GEO_SHAPE -> DataType.GEO_SHAPE;
                case DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE -> DataType.CARTESIAN_SHAPE;
                default -> DataType.NULL;
            };
        }
        return resolution;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        SpatialEnvelopeResults.Factory resultsBuilder = DataType.isSpatialGeo(this.spatialField().dataType()) ? new SpatialEnvelopeResults.Factory(SpatialCoordinateTypes.GEO, () -> new SpatialEnvelopeVisitor.GeoPointVisitor(SpatialEnvelopeVisitor.WrapLongitude.WRAP)) : new SpatialEnvelopeResults.Factory(SpatialCoordinateTypes.CARTESIAN, SpatialEnvelopeVisitor.CartesianPointVisitor::new);
        EvalOperator.ExpressionEvaluator.Factory spatial = toEvaluator.apply(this.spatialField());
        if (this.spatialDocValues) {
            if (DataType.isSpatialPoint(this.spatialField().dataType())) {
                return new StEnvelopeFromDocValuesEvaluator.Factory(this.source(), spatial, resultsBuilder::get);
            }
            throw new IllegalArgumentException("Cannot use doc values for type " + String.valueOf((Object)this.spatialField().dataType()));
        }
        return new StEnvelopeFromWKBEvaluator.Factory(this.source(), spatial, resultsBuilder::get);
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new StEnvelope(this.source(), newChildren.getFirst(), this.spatialDocValues);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, StEnvelope::new, this.spatialField());
    }

    static void buildEnvelopeResults(BytesRefBlock.Builder results, Rectangle rectangle, SpatialCoordinateTypes type) {
        long encodedMin = type.pointAsLong(rectangle.getMinX(), rectangle.getMinY());
        long encodedMax = type.pointAsLong(rectangle.getMaxX(), rectangle.getMaxY());
        double minX = type.decodeX(encodedMin);
        double minY = type.decodeY(encodedMin);
        double maxX = type.decodeX(encodedMax);
        double maxY = type.decodeY(encodedMax);
        rectangle = new Rectangle(minX, maxX, maxY, minY);
        results.appendBytesRef(SpatialCoordinateTypes.UNSPECIFIED.asWkb((Geometry)rectangle));
    }

    static void buildDocValuesEnvelopeResults(BytesRefBlock.Builder results, Rectangle rectangle) {
        results.appendBytesRef(SpatialCoordinateTypes.UNSPECIFIED.asWkb((Geometry)rectangle));
    }

    static void fromWellKnownBinary(BytesRefBlock.Builder results, int p, BytesRefBlock wkbBlock, SpatialEnvelopeResults<BytesRefBlock.Builder> resultsBuilder) {
        resultsBuilder.fromWellKnownBinary(results, p, wkbBlock, StEnvelope::buildEnvelopeResults);
    }

    static void fromDocValues(BytesRefBlock.Builder results, int p, LongBlock encodedBlock, SpatialEnvelopeResults<BytesRefBlock.Builder> resultsBuilder) {
        resultsBuilder.fromDocValues(results, p, encodedBlock, StEnvelope::buildDocValuesEnvelopeResults);
    }
}

