/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;

public class SpatialEnvelopeResults<T extends Block.Builder> {
    private final SpatialCoordinateTypes spatialCoordinateType;
    private final SpatialEnvelopeVisitor.PointVisitor pointVisitor;

    public SpatialEnvelopeResults(SpatialCoordinateTypes spatialCoordinateType, SpatialEnvelopeVisitor.PointVisitor pointVisitor) {
        this.spatialCoordinateType = spatialCoordinateType;
        this.pointVisitor = pointVisitor;
    }

    void fromWellKnownBinary(T results, int p, BytesRefBlock wkbBlock, BiConsumer<T, Rectangle> rectangleResult) {
        this.fromWellKnownBinary(results, p, wkbBlock, (T r, Rectangle rect, SpatialCoordinateTypes type) -> rectangleResult.accept(r, rect));
    }

    void fromWellKnownBinary(T results, int p, BytesRefBlock wkbBlock, TypedResultsConsumer<T> rectangleResult) {
        this.pointVisitor.reset();
        int valueCount = wkbBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        BytesRef scratch = new BytesRef();
        SpatialEnvelopeVisitor visitor = new SpatialEnvelopeVisitor(this.pointVisitor);
        int firstValueIndex = wkbBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            BytesRef wkb = wkbBlock.getBytesRef(firstValueIndex + i, scratch);
            Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
            geometry.visit((GeometryVisitor)visitor);
        }
        if (this.pointVisitor.isValid()) {
            rectangleResult.accept(results, this.pointVisitor.getResult(), this.spatialCoordinateType);
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    void fromDocValues(T results, int p, LongBlock encodedBlock, BiConsumer<T, Rectangle> rectangleResult) {
        this.pointVisitor.reset();
        int valueCount = encodedBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        int firstValueIndex = encodedBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            long encoded = encodedBlock.getLong(firstValueIndex + i);
            this.pointVisitor.visitPoint(this.spatialCoordinateType.decodeX(encoded), this.spatialCoordinateType.decodeY(encoded));
        }
        if (this.pointVisitor.isValid()) {
            rectangleResult.accept(results, this.pointVisitor.getResult());
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    void fromDocValuesLinear(DoubleBlock.Builder results, int p, LongBlock encodedBlock, double initialValue, BiFunction<Double, Long, Double> reducer) {
        int valueCount = encodedBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        double current = initialValue;
        int firstValueIndex = encodedBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            long encoded = encodedBlock.getLong(firstValueIndex + i);
            current = reducer.apply(current, encoded);
        }
        if (Double.isFinite(current)) {
            results.appendDouble(current);
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    @FunctionalInterface
    public static interface TypedResultsConsumer<T> {
        public void accept(T var1, Rectangle var2, SpatialCoordinateTypes var3);
    }

    protected static class Factory<T extends Block.Builder> {
        private final SpatialCoordinateTypes spatialCoordinateType;
        private final Supplier<SpatialEnvelopeVisitor.PointVisitor> pointVisitorSupplier;

        Factory(SpatialCoordinateTypes spatialCoordinateType, Supplier<SpatialEnvelopeVisitor.PointVisitor> pointVisitorSupplier) {
            this.spatialCoordinateType = spatialCoordinateType;
            this.pointVisitorSupplier = pointVisitorSupplier;
        }

        public SpatialEnvelopeResults<T> get(DriverContext ignored) {
            return new SpatialEnvelopeResults(this.spatialCoordinateType, this.pointVisitorSupplier.get());
        }
    }
}

