/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;

public abstract class BinarySpatialFunction
extends BinaryScalarFunction
implements SpatialEvaluatorFactory.SpatialSourceResolution {
    private static final TransportVersion ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS = TransportVersion.fromName((String)"esql_serialize_source_functions_warnings");
    protected final SpatialTypeResolver spatialTypeResolver;
    private SpatialCrsType crsType;
    protected final boolean leftDocValues;
    protected final boolean rightDocValues;
    private static final String[] GEO_TYPE_NAMES = new String[]{DataType.GEO_POINT.typeName(), DataType.GEO_SHAPE.typeName()};
    private static final String[] CARTESIAN_TYPE_NAMES = new String[]{DataType.CARTESIAN_POINT.typeName(), DataType.CARTESIAN_SHAPE.typeName()};

    protected BinarySpatialFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues, boolean pointsOnly, boolean supportsGrid) {
        super(source, left, right);
        this.leftDocValues = leftDocValues;
        this.rightDocValues = rightDocValues;
        this.spatialTypeResolver = new SpatialTypeResolver(this, pointsOnly, supportsGrid);
    }

    protected BinarySpatialFunction(StreamInput in, boolean leftDocValues, boolean rightDocValues, boolean pointsOnly, boolean supportsGrid) throws IOException {
        this(in.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS) ? Source.readFrom((PlanStreamInput)in) : Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), leftDocValues, rightDocValues, pointsOnly, supportsGrid);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS)) {
            this.source().writeTo(out);
        }
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
    }

    protected abstract Object fold(Geometry var1, Geometry var2);

    @Override
    public Object fold(FoldContext ctx) {
        Geometry leftGeom = SpatialRelatesUtils.makeGeometryFromLiteral(ctx, this.left());
        Geometry rightGeom = SpatialRelatesUtils.makeGeometryFromLiteral(ctx, this.right());
        if (leftGeom == null || rightGeom == null) {
            return null;
        }
        return this.fold(leftGeom, rightGeom);
    }

    public abstract BinarySpatialFunction withDocValues(boolean var1, boolean var2);

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.leftDocValues, this.rightDocValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            BinarySpatialFunction other = (BinarySpatialFunction)obj;
            return Objects.equals(other.children(), this.children()) && Objects.equals(other.leftDocValues, this.leftDocValues) && Objects.equals(other.rightDocValues, this.rightDocValues);
        }
        return false;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.spatialTypeResolver.resolveType();
    }

    @Override
    public void setCrsType(DataType dataType) {
        this.crsType = SpatialCrsType.fromDataType(dataType);
    }

    protected static boolean spatialCRSCompatible(DataType spatialDataType, DataType otherDataType) {
        return DataType.isSpatialGeo(spatialDataType) && DataType.isSpatialGeo(otherDataType) || !DataType.isSpatialGeo(spatialDataType) && !DataType.isSpatialGeo(otherDataType);
    }

    static String[] compatibleTypeNames(DataType spatialDataType) {
        return DataType.isSpatialGeo(spatialDataType) ? GEO_TYPE_NAMES : CARTESIAN_TYPE_NAMES;
    }

    @Override
    public SpatialCrsType crsType() {
        if (this.crsType == null) {
            this.resolveType();
        }
        return this.crsType;
    }

    @Override
    public boolean leftDocValues() {
        return this.leftDocValues;
    }

    @Override
    public boolean rightDocValues() {
        return this.rightDocValues;
    }

    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return BinarySpatialFunction.isPushableSpatialAttribute(this.left(), pushdownPredicates) && BinarySpatialFunction.isPushableLiteralAttribute(this.right()) || BinarySpatialFunction.isPushableSpatialAttribute(this.right(), pushdownPredicates) && BinarySpatialFunction.isPushableLiteralAttribute(this.left()) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    private static boolean isPushableSpatialAttribute(Expression exp, LucenePushdownPredicates p) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && DataType.isSpatial((fa = (FieldAttribute)exp).dataType()) && fa.getExactInfo().hasExact() && p.isIndexed(fa);
    }

    private static boolean isPushableLiteralAttribute(Expression exp) {
        return DataType.isSpatial(exp.dataType()) && exp.foldable();
    }

    protected static class SpatialTypeResolver {
        private final SpatialEvaluatorFactory.SpatialSourceResolution supplier;
        private final boolean pointsOnly;
        protected final boolean supportsGrid;

        SpatialTypeResolver(SpatialEvaluatorFactory.SpatialSourceResolution supplier, boolean pointsOnly, boolean supportsGrid) {
            this.supplier = supplier;
            this.pointsOnly = pointsOnly;
            this.supportsGrid = supportsGrid;
        }

        public Expression left() {
            return this.supplier.left();
        }

        public Expression right() {
            return this.supplier.right();
        }

        public String sourceText() {
            return this.supplier.source().text();
        }

        protected Expression.TypeResolution resolveType() {
            if (this.left().foldable() && !this.right().foldable() || DataType.isNull(this.left().dataType())) {
                return this.resolveType(this.right(), this.left(), TypeResolutions.ParamOrdinal.SECOND, TypeResolutions.ParamOrdinal.FIRST);
            }
            return this.resolveType(this.left(), this.right(), TypeResolutions.ParamOrdinal.FIRST, TypeResolutions.ParamOrdinal.SECOND);
        }

        protected Expression.TypeResolution isCompatibleSpatial(Expression e, TypeResolutions.ParamOrdinal paramOrd) {
            return this.pointsOnly ? EsqlTypeResolutions.isSpatialPoint(e, this.sourceText(), paramOrd) : (this.supportsGrid ? EsqlTypeResolutions.isSpatialOrGrid(e, this.sourceText(), paramOrd) : EsqlTypeResolutions.isSpatial(e, this.sourceText(), paramOrd));
        }

        protected Expression.TypeResolution isGeoPoint(Expression e, TypeResolutions.ParamOrdinal paramOrd) {
            return TypeResolutions.isType(e, DataType.GEO_POINT::equals, this.sourceText(), paramOrd, DataType.GEO_POINT.typeName());
        }

        private Expression.TypeResolution resolveType(Expression leftExpression, Expression rightExpression, TypeResolutions.ParamOrdinal leftOrdinal, TypeResolutions.ParamOrdinal rightOrdinal) {
            Expression.TypeResolution leftResolution = this.isCompatibleSpatial(leftExpression, leftOrdinal);
            Expression.TypeResolution rightResolution = this.isCompatibleSpatial(rightExpression, rightOrdinal);
            if (leftResolution.resolved()) {
                return this.resolveType(leftExpression, rightExpression, rightOrdinal);
            }
            if (rightResolution.resolved()) {
                return this.resolveType(rightExpression, leftExpression, leftOrdinal);
            }
            return leftResolution;
        }

        protected Expression.TypeResolution resolveType(Expression spatialExpression, Expression otherExpression, TypeResolutions.ParamOrdinal otherParamOrdinal) {
            if (DataType.isNull(spatialExpression.dataType())) {
                return this.isCompatibleSpatial(otherExpression, otherParamOrdinal);
            }
            Expression.TypeResolution resolution = this.isSameSpatialType(spatialExpression.dataType(), otherExpression, this.sourceText(), otherParamOrdinal);
            if (resolution.resolved() && DataType.isGeoGrid(spatialExpression.dataType())) {
                resolution = this.isGeoPoint(otherExpression, otherParamOrdinal);
            }
            if (resolution.resolved() && DataType.isGeoGrid(otherExpression.dataType())) {
                resolution = this.isGeoPoint(spatialExpression, otherParamOrdinal == TypeResolutions.ParamOrdinal.FIRST ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.FIRST);
            }
            if (resolution.unresolved()) {
                return resolution;
            }
            this.supplier.setCrsType(spatialExpression.dataType());
            return Expression.TypeResolution.TYPE_RESOLVED;
        }

        protected Expression.TypeResolution isSameSpatialType(DataType spatialDataType, Expression expression, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
            Predicate<DataType> isSpatialType = this.pointsOnly ? dt -> dt == spatialDataType : (this.supportsGrid ? dt -> DataType.isSpatialOrGrid(dt) && BinarySpatialFunction.spatialCRSCompatible(spatialDataType, dt) : dt -> DataType.isSpatial(dt) && BinarySpatialFunction.spatialCRSCompatible(spatialDataType, dt));
            return TypeResolutions.isType(expression, isSpatialType, operationName, paramOrd, BinarySpatialFunction.compatibleTypeNames(spatialDataType));
        }
    }

    public static enum SpatialCrsType {
        GEO,
        CARTESIAN,
        UNSPECIFIED;


        public static SpatialCrsType fromDataType(DataType dataType) {
            return DataType.isSpatialGeo(dataType) ? GEO : (DataType.isSpatialOrGrid(dataType) ? CARTESIAN : UNSPECIFIED);
        }
    }

    protected static abstract class BinarySpatialComparator<T> {
        protected final SpatialCoordinateTypes spatialCoordinateType;
        protected final CoordinateEncoder coordinateEncoder;
        protected final SpatialCrsType crsType;

        protected BinarySpatialComparator(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder) {
            this.spatialCoordinateType = spatialCoordinateType;
            this.coordinateEncoder = encoder;
            this.crsType = spatialCoordinateType.equals((Object)SpatialCoordinateTypes.GEO) ? SpatialCrsType.GEO : SpatialCrsType.CARTESIAN;
        }

        protected Geometry fromBytesRef(BytesRef bytesRef) {
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(bytesRef);
        }

        protected abstract T compare(BytesRef var1, BytesRef var2) throws IOException;
    }
}

