/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPSeriesWeightedSumDoubleEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvPSeriesWeightedSum
extends EsqlScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvPSeriesWeightedSum", MvPSeriesWeightedSum::new);
    private final Expression field;
    private final Expression p;

    @FunctionInfo(returnType={"double"}, description="Converts a multivalued expression into a single-valued column by multiplying every element on the input list by its corresponding term in P-Series and computing the sum.", examples={@Example(file="mv_pseries_weighted_sum", tag="example")})
    public MvPSeriesWeightedSum(Source source, @Param(name="number", type={"double"}, description="Multivalue expression.") Expression field, @Param(name="p", type={"double"}, description="It is a constant number that represents the *p* parameter in the P-Series. It impacts every element\u2019s contribution to the weighted sum.") Expression p) {
        super(source, Arrays.asList(field, p));
        this.field = field;
        this.p = p;
    }

    private MvPSeriesWeightedSum(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType(this.field, dt -> dt == DataType.DOUBLE, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "double");
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType(this.p, dt -> dt == DataType.DOUBLE, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "double");
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.p.dataType() == DataType.NULL) {
            return resolution;
        }
        return TypeResolutions.isFoldable(this.p, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
    }

    @Override
    public boolean foldable() {
        return this.field.foldable() && this.p.foldable();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.DOUBLE -> new MvPSeriesWeightedSumDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.field), ctx -> new CompensatedSum(), (Double)this.p.fold(toEvaluator.foldCtx()));
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvPSeriesWeightedSum(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MvPSeriesWeightedSum::new, this.field, this.p);
    }

    @Override
    public DataType dataType() {
        if (this.p.dataType() == DataType.NULL) {
            return DataType.NULL;
        }
        return this.field.dataType();
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock block, CompensatedSum sum, double p) {
        sum.reset(0.0, 0.0);
        int start = block.getFirstValueIndex(position);
        int end = block.getValueCount(position) + start;
        for (int i = start; i < end; ++i) {
            double current_score = block.getDouble(i) / Math.pow(i - start + 1, p);
            sum.add(current_score);
        }
        if (!Double.isFinite(sum.value())) {
            throw new ArithmeticException("double overflow");
        }
        builder.appendDouble(sum.value());
    }

    public String getWriteableName() {
        return MvPSeriesWeightedSum.ENTRY.name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.p);
    }

    Expression field() {
        return this.field;
    }

    Expression p() {
        return this.p;
    }
}

