/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class MvAvg
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvAvg", MvAvg::new);

    @FunctionInfo(returnType={"double"}, description="Converts a multivalued field into a single valued field containing the average of all of the values.", examples={@Example(file="math", tag="mv_avg")})
    public MvAvg(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Multivalue expression.") Expression field) {
        super(source, field);
    }

    private MvAvg(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvAvg.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType(this.field(), t -> t.isNumeric() && DataType.isRepresentable(t), this.sourceText(), null, "numeric");
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.DOUBLE -> new MvAvgDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvAvgIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> {
                if (this.field().dataType() == DataType.UNSIGNED_LONG) {
                    yield new MvAvgUnsignedLongEvaluator.Factory(fieldEval);
                }
                yield new MvAvgLongEvaluator.Factory(fieldEval);
            }
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvAvg(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MvAvg::new, this.field());
    }

    public static void process(CompensatedSum sum, double v) {
        sum.add(v);
    }

    public static double finish(CompensatedSum sum, int valueCount) {
        double value = sum.value();
        sum.reset(0.0, 0.0);
        return value / (double)valueCount;
    }

    static void process(CompensatedSum sum, int v) {
        sum.add((double)v);
    }

    static double single(int value) {
        return value;
    }

    static void process(CompensatedSum sum, long v) {
        sum.add((double)v);
    }

    static double single(long value) {
        return value;
    }

    static void processUnsignedLong(CompensatedSum sum, long v) {
        sum.add(EsqlDataTypeConverter.unsignedLongToDouble(v));
    }

    static double singleUnsignedLong(long value) {
        return EsqlDataTypeConverter.unsignedLongToDouble(value);
    }
}

