/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumUnsignedLongEvaluator;

public class Signum
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Signum", Signum::new);

    @FunctionInfo(returnType={"double"}, description="Returns the sign of the given number.\nIt returns `-1` for negative numbers, `0` for `0` and `1` for positive numbers.", examples={@Example(file="math", tag="signum")})
    public Signum(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Signum(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Signum.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataType.DOUBLE) {
            return new SignumDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.INTEGER) {
            return new SignumIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.LONG) {
            return new SignumLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return new SignumUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Signum(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Signum::new, this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    static double process(double val) {
        return Math.signum(val);
    }

    static double process(int val) {
        return Math.signum(val);
    }

    static double process(long val) {
        return Math.signum(val);
    }

    static double processUnsignedLong(long val) {
        return Math.signum(NumericUtils.unsignedLongToDouble((long)val));
    }
}

