/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt10Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt5Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt6Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt7Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt8Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt9Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToIntBinarySearchEvaluator;

class RoundToInt {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        int[] f = points.stream().mapToInt(p -> ((Number)p).intValue()).toArray();
        return switch (f.length) {
            case 1 -> new RoundToInt1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToInt2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToInt3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToInt4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5 -> new RoundToInt5Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4]);
            case 6 -> new RoundToInt6Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5]);
            case 7 -> new RoundToInt7Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6]);
            case 8 -> new RoundToInt8Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7]);
            case 9 -> new RoundToInt9Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8]);
            case 10 -> new RoundToInt10Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8], f[9]);
            default -> new RoundToIntBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToInt() {
    }

    static int process(int field, int[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static int process(int field, int p0) {
        return p0;
    }

    static int process(int field, int p0, int p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static int process(int field, int p0, int p1, int p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static int process(int field, int p0, int p1, int p2, int p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        if (field < p4) {
            return p3;
        }
        return p4;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4, int p5) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p4) {
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p5) {
            return p4;
        }
        return p5;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4, int p5, int p6) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        return p6;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        return p7;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p6) {
            if (field < p5) {
                return p4;
            }
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        return p8;
    }

    static int process(int field, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, int p9) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p7) {
            if (field < p5) {
                return p4;
            }
            if (field < p6) {
                return p5;
            }
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        if (field < p9) {
            return p8;
        }
        return p9;
    }
}

