/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkDirectionUtils;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.NetworkDirectionEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class NetworkDirection
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "NetworkDirection", NetworkDirection::new);
    private final Expression sourceIpField;
    private final Expression destinationIpField;
    private final Expression internalNetworks;

    @FunctionInfo(returnType={"keyword"}, preview=true, description="Returns the direction type (inbound, outbound, internal, external) given a source IP address, destination IP address, and a list of internal networks.", examples={@Example(file="ip", tag="networkDirectionFromRowWithInlineNetworks")})
    public NetworkDirection(Source source, @Param(name="source_ip", type={"ip"}, description="Source IP address of type `ip` (both IPv4 and IPv6 are supported).") Expression sourceIpField, @Param(name="destination_ip", type={"ip"}, description="Destination IP address of type `ip` (both IPv4 and IPv6 are supported).") Expression destinationIpField, @Param(name="internal_networks", type={"keyword", "text"}, description="List of internal networks. Supports IPv4 and IPv6 addresses, ranges in CIDR notation, and named ranges.") Expression internalNetworks) {
        super(source, Arrays.asList(sourceIpField, destinationIpField, internalNetworks));
        this.sourceIpField = sourceIpField;
        this.destinationIpField = destinationIpField;
        this.internalNetworks = internalNetworks;
    }

    private NetworkDirection(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.sourceIpField);
        out.writeNamedWriteable((NamedWriteable)this.destinationIpField);
        out.writeNamedWriteable((NamedWriteable)this.internalNetworks);
    }

    public String getWriteableName() {
        return NetworkDirection.ENTRY.name;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new NetworkDirection(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, NetworkDirection::new, this.sourceIpField, this.destinationIpField, this.internalNetworks);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory sourceIpEvaluatorSupplier = toEvaluator.apply(this.sourceIpField);
        EvalOperator.ExpressionEvaluator.Factory destinationIpEvaluatorSupplier = toEvaluator.apply(this.destinationIpField);
        EvalOperator.ExpressionEvaluator.Factory internalNetworksEvaluatorSupplier = toEvaluator.apply(this.internalNetworks);
        return new NetworkDirectionEvaluator.Factory(this.source(), context -> new BytesRef(16), context -> new BytesRef(), sourceIpEvaluatorSupplier, destinationIpEvaluatorSupplier, internalNetworksEvaluatorSupplier);
    }

    static void process(BytesRefBlock.Builder builder, BytesRef scratch, BytesRef netScratch, BytesRef sourceIp, BytesRef destinationIp, int position, BytesRefBlock networks) {
        int i;
        int valueCount = networks.getValueCount(position);
        if (valueCount == 0) {
            builder.appendNull();
            return;
        }
        int first = networks.getFirstValueIndex(position);
        System.arraycopy(sourceIp.bytes, sourceIp.offset, scratch.bytes, 0, sourceIp.length);
        InetAddress sourceIpAddress = InetAddressPoint.decode((byte[])scratch.bytes);
        System.arraycopy(destinationIp.bytes, destinationIp.offset, scratch.bytes, 0, destinationIp.length);
        InetAddress destinationIpAddress = InetAddressPoint.decode((byte[])scratch.bytes);
        boolean sourceInternal = false;
        boolean destinationInternal = false;
        for (i = first; i < first + valueCount; ++i) {
            if (!NetworkDirectionUtils.inNetwork((InetAddress)sourceIpAddress, (String)networks.getBytesRef(i, netScratch).utf8ToString())) continue;
            sourceInternal = true;
            break;
        }
        for (i = first; i < first + valueCount; ++i) {
            if (!NetworkDirectionUtils.inNetwork((InetAddress)destinationIpAddress, (String)networks.getBytesRef(i, netScratch).utf8ToString())) continue;
            destinationInternal = true;
            break;
        }
        builder.appendBytesRef(new BytesRef((CharSequence)NetworkDirectionUtils.getDirection((boolean)sourceInternal, (boolean)destinationInternal)));
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isIPAndExact(this.sourceIpField, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isIPAndExact(this.destinationIpField, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND)).and(EsqlTypeResolutions.isStringAndExact(this.internalNetworks, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD));
    }

    public Expression sourceIpField() {
        return this.sourceIpField;
    }

    public Expression destinationIpField() {
        return this.destinationIpField;
    }

    public Expression internalNetworks() {
        return this.internalNetworks;
    }

    @Override
    public boolean foldable() {
        return this.sourceIpField.foldable() && this.destinationIpField.foldable() && this.internalNetworks.foldable();
    }
}

