/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.IpPrefixEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class IpPrefix
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IpPrefix", IpPrefix::new);
    private static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private final Expression ipField;
    private final Expression prefixLengthV4Field;
    private final Expression prefixLengthV6Field;

    @FunctionInfo(returnType={"ip"}, description="Truncates an IP to a given prefix length.", examples={@Example(file="ip", tag="ipPrefix")})
    public IpPrefix(Source source, @Param(name="ip", type={"ip"}, description="IP address of type `ip` (both IPv4 and IPv6 are supported).") Expression ipField, @Param(name="prefixLengthV4", type={"integer"}, description="Prefix length for IPv4 addresses.") Expression prefixLengthV4Field, @Param(name="prefixLengthV6", type={"integer"}, description="Prefix length for IPv6 addresses.") Expression prefixLengthV6Field) {
        super(source, Arrays.asList(ipField, prefixLengthV4Field, prefixLengthV6Field));
        this.ipField = ipField;
        this.prefixLengthV4Field = prefixLengthV4Field;
        this.prefixLengthV6Field = prefixLengthV6Field;
    }

    private IpPrefix(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.ipField);
        out.writeNamedWriteable((NamedWriteable)this.prefixLengthV4Field);
        out.writeNamedWriteable((NamedWriteable)this.prefixLengthV6Field);
    }

    public String getWriteableName() {
        return IpPrefix.ENTRY.name;
    }

    public Expression ipField() {
        return this.ipField;
    }

    public Expression prefixLengthV4Field() {
        return this.prefixLengthV4Field;
    }

    public Expression prefixLengthV6Field() {
        return this.prefixLengthV6Field;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory ipEvaluatorSupplier = toEvaluator.apply(this.ipField);
        EvalOperator.ExpressionEvaluator.Factory prefixLengthV4EvaluatorSupplier = toEvaluator.apply(this.prefixLengthV4Field);
        EvalOperator.ExpressionEvaluator.Factory prefixLengthV6EvaluatorSupplier = toEvaluator.apply(this.prefixLengthV6Field);
        return new IpPrefixEvaluator.Factory(this.source(), ipEvaluatorSupplier, prefixLengthV4EvaluatorSupplier, prefixLengthV6EvaluatorSupplier, context -> new BytesRef(new byte[16]));
    }

    static BytesRef process(BytesRef ip, int prefixLengthV4, int prefixLengthV6, BytesRef scratch) {
        boolean isIpv4;
        if (prefixLengthV4 < 0 || prefixLengthV4 > 32) {
            throw new IllegalArgumentException("Prefix length v4 must be in range [0, 32], found " + prefixLengthV4);
        }
        if (prefixLengthV6 < 0 || prefixLengthV6 > 128) {
            throw new IllegalArgumentException("Prefix length v6 must be in range [0, 128], found " + prefixLengthV6);
        }
        boolean bl = isIpv4 = Arrays.compareUnsigned(ip.bytes, ip.offset, ip.offset + IPV4_PREFIX.length, IPV4_PREFIX, 0, IPV4_PREFIX.length) == 0;
        if (isIpv4) {
            IpPrefix.makePrefix(ip, scratch, 12 + prefixLengthV4 / 8, prefixLengthV4 % 8);
        } else {
            IpPrefix.makePrefix(ip, scratch, prefixLengthV6 / 8, prefixLengthV6 % 8);
        }
        return scratch;
    }

    private static void makePrefix(BytesRef ip, BytesRef scratch, int fullBytes, int remainingBits) {
        System.arraycopy(ip.bytes, ip.offset, scratch.bytes, 0, fullBytes);
        if (remainingBits > 0) {
            byte lastByteMask = (byte)(255 << 8 - remainingBits);
            scratch.bytes[fullBytes] = (byte)(ip.bytes[ip.offset + fullBytes] & lastByteMask);
        }
        if (fullBytes < 16) {
            Arrays.fill(scratch.bytes, fullBytes + 1, 16, (byte)0);
        }
    }

    @Override
    public DataType dataType() {
        return DataType.IP;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isIPAndExact(this.ipField, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType(this.prefixLengthV4Field, dt -> dt == DataType.INTEGER, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "integer")).and(TypeResolutions.isType(this.prefixLengthV6Field, dt -> dt == DataType.INTEGER, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD, "integer"));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new IpPrefix(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, IpPrefix::new, this.ipField, this.prefixLengthV4Field, this.prefixLengthV6Field);
    }
}

