/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.internal;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.internal.InternalPacks;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class PackDimension
extends UnaryScalarFunction {
    public PackDimension(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndHistogram(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("PackDimension must be used on the coordinator only");
    }

    @Override
    public DataType dataType() {
        return DataType.SOURCE;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new PackDimension(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, PackDimension::new, this.field());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ElementType elementType = PlannerUtils.toElementType(this.field.dataType());
        return switch (elementType) {
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            case ElementType.BYTES_REF -> ctx -> new PackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.packBytesValues(ctx, (BytesRefBlock)block));
            case ElementType.LONG -> ctx -> new PackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.packLongValues(ctx, (LongBlock)block));
            case ElementType.INT -> ctx -> new PackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.packIntValues(ctx, (IntBlock)block));
            case ElementType.BOOLEAN -> ctx -> new PackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.packBooleanValues(ctx, (BooleanBlock)block));
            default -> throw new IllegalStateException("unsupported element type [" + String.valueOf((Object)this.field.dataType()) + "]");
        };
    }

    record PackValuesEvaluator(EvalOperator.ExpressionEvaluator field, Function<Block, BytesRefBlock> pack) implements EvalOperator.ExpressionEvaluator
    {
        static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(PackValuesEvaluator.class);

        public BytesRefBlock eval(Page page) {
            try (Block fieldVal = this.field.eval(page);){
                BytesRefBlock result = this.pack.apply(fieldVal);
                assert (!result.doesHaveMultivaluedFields()) : "packed block must not have multi-valued";
                BytesRefBlock bytesRefBlock = result;
                return bytesRefBlock;
            }
        }

        @Override
        public String toString() {
            return "PackDimension[field=" + String.valueOf(this.field) + "]";
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
        }

        public void close() {
            Releasables.close((Releasable)this.field);
        }
    }
}

