/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.histogram;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramQuantile;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.HistogramPercentileExponentialHistogramEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.HistogramPercentileTDigestEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class HistogramPercentile
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "HistogramPercentile", HistogramPercentile::new);
    private final Expression histogram;
    private final Expression percentile;

    @FunctionInfo(returnType={"double"})
    public HistogramPercentile(Source source, @Param(name="histogram", type={"exponential_histogram", "tdigest"}) Expression histogram, @Param(name="percentile", type={"double", "integer", "long", "unsigned_long"}) Expression percentile) {
        super(source, List.of(histogram, percentile));
        this.histogram = histogram;
        this.percentile = percentile;
    }

    private HistogramPercentile(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    Expression histogram() {
        return this.histogram;
    }

    Expression percentile() {
        return this.percentile;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.histogram, dt -> dt == DataType.EXPONENTIAL_HISTOGRAM || dt == DataType.TDIGEST, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "exponential_histogram", "tdigest").and(TypeResolutions.isType(this.percentile, DataType::isNumeric, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "numeric types"));
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new HistogramPercentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public boolean foldable() {
        return this.histogram.foldable() && this.percentile.foldable();
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, HistogramPercentile::new, this.histogram, this.percentile);
    }

    public String getWriteableName() {
        return HistogramPercentile.ENTRY.name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.histogram);
        out.writeNamedWriteable((NamedWriteable)this.percentile);
    }

    static void process(DoubleBlock.Builder resultBuilder, ExponentialHistogram value, double percentile) {
        HistogramPercentile.checkPercentileRange(percentile);
        double result = ExponentialHistogramQuantile.getQuantile((ExponentialHistogram)value, (double)(percentile / 100.0));
        if (Double.isNaN(result)) {
            resultBuilder.appendNull();
        } else {
            resultBuilder.appendDouble(result);
        }
    }

    static void process(DoubleBlock.Builder resultBuilder, TDigestHolder value, double percentile, CircuitBreaker breaker) {
        HistogramPercentile.checkPercentileRange(percentile);
        try (TDigestState scratch = TDigestState.create((CircuitBreaker)breaker, (double)100.0);){
            value.addTo(scratch);
            double result = scratch.quantile(percentile / 100.0);
            if (Double.isNaN(result)) {
                resultBuilder.appendNull();
            } else {
                resultBuilder.appendDouble(result);
            }
        }
    }

    private static void checkPercentileRange(double percentile) {
        if (percentile < 0.0 || percentile > 100.0) {
            throw new ArithmeticException("Percentile value must be in the range [0, 100], got: " + percentile);
        }
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.histogram);
        EvalOperator.ExpressionEvaluator.Factory percentileEvaluator = Cast.cast(this.source(), this.percentile.dataType(), DataType.DOUBLE, toEvaluator.apply(this.percentile));
        DataType valueType = this.histogram.dataType();
        return switch (valueType) {
            case DataType.EXPONENTIAL_HISTOGRAM -> new HistogramPercentileExponentialHistogramEvaluator.Factory(this.source(), fieldEvaluator, percentileEvaluator);
            case DataType.TDIGEST -> new HistogramPercentileTDigestEvaluator.Factory(this.source(), fieldEvaluator, percentileEvaluator, DriverContext::breaker);
            default -> throw EsqlIllegalArgumentException.illegalDataType(valueType);
        };
    }
}

