/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class TRange
extends EsqlConfigurationFunction
implements OptionalArgument,
SurrogateExpression,
PostAnalysisPlanVerificationAware,
TimestampAware {
    public static final String NAME = "TRange";
    public static final String START_TIME_OR_OFFSET_PARAMETER = "start_time_or_offset";
    public static final String END_TIME_PARAMETER = "end_time";
    private final Expression first;
    private final Expression second;
    private final Expression timestamp;

    @FunctionInfo(returnType={"boolean"}, description="Filters data for the given time range using the @timestamp attribute.", examples={@Example(file="trange", tag="docsTRangeOffsetFromNow"), @Example(file="trange", tag="docsTRangeAbsoluteTimeString"), @Example(file="trange", tag="docsTRangeAbsoluteTimeDateTime"), @Example(file="trange", tag="docsTRangeAbsoluteTimeDateTimeNanos"), @Example(file="trange", tag="docsTRangeAbsoluteTimeEpochMillis")})
    public TRange(Source source, @Param(name="start_time_or_offset", type={"time_duration", "date_period", "date", "date_nanos", "keyword", "long"}, description=" Offset from NOW for the single parameter mode. Start time for two parameter mode.\n In two parameter mode, the start time value can be a date string, date, date_nanos or epoch milliseconds.\n") Expression first, @Param(name="end_time", type={"keyword", "long", "date", "date_nanos"}, description="Explicit end time that can be a date string, date, date_nanos or epoch milliseconds.", optional=true) Expression second, Expression timestamp, Configuration configuration) {
        super(source, second != null ? List.of(first, second, timestamp) : List.of(first, timestamp), configuration);
        this.first = first;
        this.second = second;
        this.timestamp = timestamp;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("should be rewritten");
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public boolean foldable() {
        return this.timestamp.foldable() && this.first.foldable() && (this.second == null || this.second.foldable());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        String operationName = this.sourceText();
        Expression.TypeResolution resolution = TypeResolutions.isType(this.timestamp, DataType::isMillisOrNanos, operationName, TypeResolutions.ParamOrdinal.DEFAULT, true, "date_nanos", "date");
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.second == null) {
            return TypeResolutions.isNotNull(this.first, operationName, TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isFoldable(this.first, operationName, TypeResolutions.ParamOrdinal.FIRST)).and(TypeResolutions.isType(this.first, DataType::isTemporalAmount, operationName, TypeResolutions.ParamOrdinal.FIRST, "time_duration", "date_period"));
        }
        resolution = TypeResolutions.isNotNull(this.first, operationName, TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isFoldable(this.first, operationName, TypeResolutions.ParamOrdinal.FIRST)).and(TypeResolutions.isNotNull(this.second, operationName, TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isFoldable(this.second, operationName, TypeResolutions.ParamOrdinal.SECOND));
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType(this.first, dt -> DataType.isMillisOrNanos(dt) || dt == DataType.KEYWORD || dt == DataType.LONG, operationName, TypeResolutions.ParamOrdinal.FIRST, "string", "long", "date", "date_nanos").and(TypeResolutions.isType(this.second, dt -> dt == this.first.dataType(), operationName, TypeResolutions.ParamOrdinal.SECOND, this.first.dataType().esType()));
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new TRange(this.source(), newChildren.getFirst(), newChildren.size() == 3 ? newChildren.get(1) : null, newChildren.getLast(), this.configuration());
    }

    @Override
    public Expression surrogate() {
        long[] range = this.getRange(FoldContext.small());
        Literal startLiteral = new Literal(this.source(), range[0], this.timestamp.dataType());
        Literal endLiteral = new Literal(this.source(), range[1], this.timestamp.dataType());
        return new And(this.source(), new GreaterThan(this.source(), this.timestamp, startLiteral), new LessThanOrEqual(this.source(), this.timestamp, endLiteral));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, TRange::new, this.first, this.second, this.timestamp, this.configuration());
    }

    @Override
    public Nullability nullable() {
        return this.timestamp.nullable();
    }

    private long[] getRange(FoldContext foldContext) {
        Instant rangeStart;
        Instant rangeEnd;
        try {
            Object foldFirst = this.first.fold(foldContext);
            if (this.second == null) {
                rangeEnd = this.configuration().now().toInstant();
                rangeStart = this.timeWithOffset(foldFirst, rangeEnd);
            } else {
                Object foldSecond = this.second.fold(foldContext);
                rangeStart = this.parseToInstant(foldFirst, START_TIME_OR_OFFSET_PARAMETER);
                rangeEnd = this.parseToInstant(foldSecond, END_TIME_PARAMETER);
            }
        }
        catch (InvalidArgumentException e) {
            throw new InvalidArgumentException((Throwable)e, "invalid time range for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
        }
        if (rangeStart.isAfter(rangeEnd)) {
            throw new InvalidArgumentException("TRANGE rangeStart time [{}] must be before rangeEnd time [{}]", new Object[]{rangeStart, rangeEnd});
        }
        if (this.timestamp.dataType() == DataType.DATE_NANOS && this.first.dataType() == DataType.DATE_NANOS) {
            return new long[]{DateUtils.toLong((Instant)rangeStart), DateUtils.toLong((Instant)rangeEnd)};
        }
        boolean convertToNanos = this.timestamp.dataType() == DataType.DATE_NANOS;
        return new long[]{convertToNanos ? DateUtils.toNanoSeconds((long)rangeStart.toEpochMilli()) : rangeStart.toEpochMilli(), convertToNanos ? DateUtils.toNanoSeconds((long)rangeEnd.toEpochMilli()) : rangeEnd.toEpochMilli()};
    }

    private Instant timeWithOffset(Object offset, Instant base) {
        if (offset instanceof TemporalAmount) {
            TemporalAmount amount = (TemporalAmount)offset;
            return base.minus(amount);
        }
        throw new InvalidArgumentException("Unsupported offset type [{}]", new Object[]{offset.getClass().getSimpleName()});
    }

    private Instant parseToInstant(Object value, String paramName) {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            value = literal.fold(FoldContext.small());
        }
        if (value instanceof Instant) {
            Instant instantValue = (Instant)value;
            return instantValue;
        }
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            try {
                long millis = EsqlDataTypeConverter.dateTimeToLong(bytesRef.utf8ToString());
                return Instant.ofEpochMilli(millis);
            }
            catch (Exception e) {
                throw new InvalidArgumentException("TRANGE {} parameter must be a valid datetime string, got: {}", new Object[]{paramName, value});
            }
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return Instant.ofEpochMilli(longValue);
        }
        throw new InvalidArgumentException("Unsupported time value type [{}] for parameter [{}]", new Object[]{value.getClass().getSimpleName(), paramName});
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (logicalPlan, failures) -> {
            Object rangeEndValue;
            Period period;
            Duration duration;
            Object rangeStartValue;
            if (this.second == null && ((rangeStartValue = this.first.fold(FoldContext.small())) instanceof Duration && (duration = (Duration)rangeStartValue).isNegative() || rangeStartValue instanceof Period && (period = (Period)rangeStartValue).isNegative())) {
                failures.add(Failure.fail(this.first, "{} cannot be negative", START_TIME_OR_OFFSET_PARAMETER));
            }
            if (this.second != null && (rangeEndValue = this.second.fold(FoldContext.small())) == null) {
                failures.add(Failure.fail(this.second, "{} cannot be null", END_TIME_PARAMETER));
            }
        };
    }
}

