/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class DateParse
extends EsqlScalarFunction
implements TwoOptionalArguments {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateParse", DateParse::new);
    private static final String TIME_ZONE_PARAM_NAME = "time_zone";
    private static final String LOCALE_PARAM_NAME = "locale";
    private final Expression first;
    private final Expression second;
    private final Expression third;
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry("time_zone", DataType.KEYWORD), Map.entry("locale", DataType.KEYWORD));

    @FunctionInfo(returnType={"date"}, description="Returns a date by parsing the second argument using the format specified in the first argument.", examples={@Example(file="docs", tag="dateParse")})
    public DateParse(Source source, @Param(name="datePattern", type={"keyword", "text"}, description="The date format. Refer to the\n{javadoc14}/java.base/java/time/format/DateTimeFormatter.html[`DateTimeFormatter` documentation] for the syntax.\nIf `null`, the function returns `null`.", optional=true) Expression first, @Param(name="dateString", type={"keyword", "text"}, description="Date expression as a string. If `null` or an empty string, the function returns `null`.") Expression second, @MapParam(name="options", params={@MapParam.MapParamEntry(name="time_zone", type={"keyword"}, valueHint={"standard"}, description="Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC."), @MapParam.MapParamEntry(name="locale", type={"keyword"}, valueHint={"standard"}, description="The locale to use when parsing the date, relevant when parsing month names or week days.")}, description="(Optional) Additional options for date parsing, specifying time zone and locale as <<esql-function-named-params,function named parameters>>.", optional=true) Expression third) {
        super(source, DateParse.fields(first, second, third));
        this.first = first;
        this.second = second;
        this.third = third;
    }

    private static List<Expression> fields(Expression first, Expression second, Expression third) {
        ArrayList<Expression> list = new ArrayList<Expression>(3);
        list.add(first);
        if (second != null) {
            list.add(second);
        }
        if (third != null) {
            list.add(third);
        }
        return list;
    }

    private Expression field() {
        if (this.second instanceof MapExpression) {
            return this.first;
        }
        return this.second != null ? this.second : this.first;
    }

    private Expression format() {
        if (this.second instanceof MapExpression || this.second == null) {
            return null;
        }
        return this.first;
    }

    private Expression options() {
        if (this.second instanceof MapExpression) {
            return this.second;
        }
        return this.third;
    }

    private DateParse(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeOptionalNamedWriteable(this.children().size() > 1 ? (NamedWriteable)this.children().get(1) : null);
        out.writeOptionalNamedWriteable(this.children().size() > 2 ? (NamedWriteable)this.children().get(2) : null);
    }

    public String getWriteableName() {
        return DateParse.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.DATETIME;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression format = this.format();
        if (format != null && (resolution = EsqlTypeResolutions.isStringAndExact(format, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        Expression field = this.field();
        resolution = TypeResolutions.isString(field, this.sourceText(), format != null ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        Expression options = this.options();
        if (options != null && (resolution = TypeResolutions.isMapExpression(options, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD)).unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public boolean foldable() {
        Expression field = this.field();
        Expression format = this.format();
        return field.foldable() && (format == null || format.foldable());
    }

    public static long process(BytesRef val, DateFormatter formatter) throws IllegalArgumentException {
        return EsqlDataTypeConverter.dateTimeToLong(val.utf8ToString(), formatter);
    }

    static long process(BytesRef val, BytesRef formatter) throws IllegalArgumentException {
        return EsqlDataTypeConverter.dateTimeToLong(val.utf8ToString(), DateParse.toFormatter(formatter));
    }

    private Map<String, Object> parseOptions() throws InvalidArgumentException {
        HashMap<String, Object> matchOptions = new HashMap<String, Object>();
        Expression options = this.options();
        if (options == null) {
            return matchOptions;
        }
        Options.populateMap((MapExpression)options, matchOptions, this.source(), TypeResolutions.ParamOrdinal.THIRD, ALLOWED_OPTIONS);
        return matchOptions;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        Expression field = this.field();
        Expression format = this.format();
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(field);
        if (format == null) {
            return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER);
        }
        if (!DataType.isString(format.dataType())) {
            throw new IllegalArgumentException("unsupported data type for date_parse [" + String.valueOf((Object)format.dataType()) + "]");
        }
        Map<String, Object> parsedOptions = this.parseOptions();
        String localeAsString = (String)parsedOptions.get(LOCALE_PARAM_NAME);
        Locale locale = localeAsString == null ? null : LocaleUtils.parse((String)localeAsString);
        String timezoneAsString = (String)parsedOptions.get(TIME_ZONE_PARAM_NAME);
        ZoneId timezone = null;
        try {
            if (timezoneAsString != null) {
                timezone = ZoneId.of(timezoneAsString);
            }
        }
        catch (ZoneRulesException e) {
            throw new IllegalArgumentException("unsupported timezone [" + timezoneAsString + "]");
        }
        if (format.foldable()) {
            try {
                DateFormatter formatter = DateParse.toFormatter(format.fold(toEvaluator.foldCtx()));
                if (locale != null) {
                    formatter = formatter.withLocale(locale);
                }
                if (timezone != null) {
                    formatter = formatter.withZone(timezone);
                }
                return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException((Throwable)e, "invalid date pattern for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
            }
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(format);
        return new DateParseEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator);
    }

    private static DateFormatter toFormatter(Object format) {
        return DateFormatter.forPattern((String)((BytesRef)format).utf8ToString());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateParse(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null, newChildren.size() > 2 ? newChildren.get(2) : null);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        Expression format = this.format();
        Expression field = this.field();
        Expression options = this.options();
        Expression first = format != null ? format : field;
        Expression second = format != null ? field : null;
        return NodeInfo.create(this, DateParse::new, first, second, options);
    }
}

