/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractConstantMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractConstantNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractNanosEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class DateExtract
extends EsqlConfigurationFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateExtract", DateExtract::new);
    private ChronoField chronoField;

    @FunctionInfo(returnType={"long"}, description="Extracts parts of a date, like year, month, day, hour.", examples={@Example(file="date", tag="dateExtract"), @Example(file="date", tag="docsDateExtractBusinessHours", description="Find all events that occurred outside of business hours (before 9 AM or after 5PM), on any given date:")})
    public DateExtract(Source source, @Param(name="datePart", type={"keyword", "text"}, description="Part of the date to extract.\n\nCan be: `aligned_day_of_week_in_month`, `aligned_day_of_week_in_year`, `aligned_week_of_month`, `aligned_week_of_year`,\n`ampm_of_day`, `clock_hour_of_ampm`, `clock_hour_of_day`, `day_of_month`, `day_of_week`, `day_of_year`, `epoch_day`,\n`era`, `hour_of_ampm`, `hour_of_day`, `instant_seconds`, `micro_of_day`, `micro_of_second`, `milli_of_day`,\n`milli_of_second`, `minute_of_day`, `minute_of_hour`, `month_of_year`, `nano_of_day`, `nano_of_second`,\n`offset_seconds`, `proleptic_month`, `second_of_day`, `second_of_minute`, `year`, or `year_of_era`.\nRefer to {javadoc8}/java/time/temporal/ChronoField.html[java.time.temporal.ChronoField]\nfor a description of these values.\n\nIf `null`, the function returns `null`.") Expression chronoFieldExp, @Param(name="date", type={"date", "date_nanos"}, description="Date expression. If `null`, the function returns `null`.") Expression field, Configuration configuration) {
        super(source, List.of(chronoFieldExp, field), configuration);
    }

    private DateExtract(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.datePart());
        out.writeNamedWriteable((NamedWriteable)this.field());
    }

    Expression datePart() {
        return (Expression)this.children().get(0);
    }

    Expression field() {
        return (Expression)this.children().get(1);
    }

    public String getWriteableName() {
        return DateExtract.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        boolean isNanos = switch (this.field().dataType()) {
            case DataType.DATETIME -> false;
            case DataType.DATE_NANOS -> true;
            default -> throw new UnsupportedOperationException("Unsupported field type [" + this.field().dataType().name() + "]. If you're seeing this, there\u2019s a bug in DateExtract.resolveType");
        };
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply((Expression)this.children().get(1));
        if (((Expression)this.children().get(0)).foldable()) {
            ChronoField chrono = this.chronoField(toEvaluator.foldCtx());
            if (chrono == null) {
                BytesRef field = (BytesRef)((Expression)this.children().get(0)).fold(toEvaluator.foldCtx());
                throw new InvalidArgumentException("invalid date field for [{}]: {}", new Object[]{this.sourceText(), field.utf8ToString()});
            }
            if (isNanos) {
                return new DateExtractConstantNanosEvaluator.Factory(this.source(), fieldEvaluator, chrono, this.configuration().zoneId());
            }
            return new DateExtractConstantMillisEvaluator.Factory(this.source(), fieldEvaluator, chrono, this.configuration().zoneId());
        }
        EvalOperator.ExpressionEvaluator.Factory chronoEvaluator = toEvaluator.apply((Expression)this.children().get(0));
        if (isNanos) {
            return new DateExtractNanosEvaluator.Factory(this.source(), fieldEvaluator, chronoEvaluator, this.configuration().zoneId());
        }
        return new DateExtractMillisEvaluator.Factory(this.source(), fieldEvaluator, chronoEvaluator, this.configuration().zoneId());
    }

    private ChronoField chronoField(FoldContext ctx) {
        if (this.chronoField == null) {
            Expression field = (Expression)this.children().get(0);
            try {
                if (field.foldable() && DataType.isString(field.dataType())) {
                    this.chronoField = (ChronoField)EsqlDataTypeConverter.EsqlConverter.STRING_TO_CHRONO_FIELD.convert(field.fold(ctx));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.chronoField;
    }

    static long processMillis(long value, BytesRef chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLong(value, chronoField, zone);
    }

    static long processMillis(long value, ChronoField chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLong(value, chronoField, zone);
    }

    static long processNanos(long value, BytesRef chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLongNanos(value, chronoField, zone);
    }

    static long processNanos(long value, ChronoField chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLongNanos(value, chronoField, zone);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateExtract(this.source(), newChildren.get(0), newChildren.get(1), this.configuration());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, DateExtract::new, (Expression)this.children().get(0), (Expression)this.children().get(1), this.configuration());
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        String operationName = this.sourceText();
        return EsqlTypeResolutions.isStringAndExact((Expression)this.children().get(0), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.children().get(1), DataType::isDate, operationName, TypeResolutions.ParamOrdinal.SECOND, "datetime or date_nanos"));
    }

    @Override
    public boolean foldable() {
        return ((Expression)this.children().get(0)).foldable() && ((Expression)this.children().get(1)).foldable();
    }
}

