/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongBase;

public class ToLongSurrogate
extends EsqlScalarFunction
implements SurrogateExpression,
OptionalArgument,
ConvertFunction {
    private final Expression field;
    private final Expression base;

    @FunctionInfo(returnType={"long"}, description="Converts the input value to a long.\nIf the input parameter is of a date type, its value will be interpreted as milliseconds\nsince the {wikipedia}/Unix_time[Unix epoch], converted to long.\nBoolean `true` will be converted to long `1`, `false` to `0`.", detailedDescription="When given two arguments, a string value and a whole number base,\nthe string is parsed as a long in the given base.\nIf parsing fails a warning is generated as described below and the result is null.\nA leading '0x' prefix is allowed for base 16.\n{applies_to}`stack: ga 9.3`\n", examples={@Example(file="ints", tag="to_long-str", explanation="Note in this example the last conversion of the string isn\u2019t possible.\nWhen this happens, the result is a `null` value.\nIn this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:113: evaluation of [TO_LONG(str3)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.NumberFormatException: For input string: \"foo\"\"`"), @Example(file="ints", tag="to_long_base-str1", explanation="This example demonstrates parsing a base 16 value and a base 13 value. {applies_to}`stack: ga 9.3`"), @Example(file="ints", tag="to_long_base-str2", explanation="This example demonstrates parsing a string that is valid in base 36 but invalid in base 10.Observe in the second case a warning is generated and null is returned. {applies_to}`stack: ga 9.3`")})
    public ToLongSurrogate(Source source, @Param(name="field", type={"boolean", "date", "date_nanos", "keyword", "text", "double", "long", "unsigned_long", "integer", "counter_integer", "counter_long", "geohash", "geotile", "geohex"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field, @Param(optional=true, name="base", type={"integer", "long", "unsigned_long"}, description="(Optional) Radix or base used to convert the input value.When a base is specified the input type must be `keyword` or `text`.{applies_to}`stack: ga 9.3`") Expression base) {
        super(source, base == null ? List.of(field) : List.of(field, base));
        this.field = field;
        this.base = base;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("should be rewritten");
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.base != null) {
            Expression.TypeResolution resolution = TypeResolutions.isString(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
            if (resolution.resolved()) {
                resolution = TypeResolutions.isWholeNumber(this.base, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
            }
            return resolution;
        }
        return new ToLong(this.source(), this.field).resolveType();
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToLongSurrogate(this.source(), newChildren.get(0), newChildren.size() == 1 ? null : newChildren.get(1));
    }

    @Override
    public Expression surrogate() {
        if (this.base != null) {
            switch (this.field.dataType()) {
                case KEYWORD: 
                case TEXT: 
                case NULL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("may not specify base with non-string field " + String.valueOf((Object)this.field.dataType()));
                }
            }
            switch (this.base.dataType()) {
                case NULL: 
                case INTEGER: 
                case LONG: 
                case UNSIGNED_LONG: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("base must be a whole number, not " + String.valueOf((Object)this.base.dataType()));
                }
            }
            return new ToLongBase(this.source(), this.field, new ToInteger(this.source(), this.base));
        }
        return new ToLong(this.source(), this.field);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToLongSurrogate::new, this.field, this.base);
    }

    @Override
    public Expression field() {
        return this.field;
    }

    @Override
    public Set<DataType> supportedTypes() {
        return ToLong.EVALUATORS.keySet();
    }
}

