/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromBase64Evaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class FromBase64
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FromBase64", FromBase64::new);

    @FunctionInfo(returnType={"keyword"}, description="Decode a base64 string.", examples={@Example(file="string", tag="from_base64")})
    public FromBase64(Source source, @Param(name="string", type={"keyword", "text"}, description="A base64 string.") Expression string) {
        super(source, string);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    private FromBase64(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return FromBase64.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new FromBase64(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, FromBase64::new, this.field());
    }

    static BytesRef process(BytesRef field, BytesRefBuilder oScratch) {
        byte[] bytes = new byte[field.length];
        System.arraycopy(field.bytes, field.offset, bytes, 0, field.length);
        oScratch.grow(field.length);
        oScratch.clear();
        int decodedSize = Base64.getDecoder().decode(bytes, oScratch.bytes());
        return new BytesRef(oScratch.bytes(), 0, decodedSize);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.BYTES_REF -> new FromBase64Evaluator.Factory(this.source(), toEvaluator.apply(this.field), context -> new BytesRefBuilder());
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }
}

