/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.blockloader.BlockLoaderExpression;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class FromAggregateMetricDouble
extends EsqlScalarFunction
implements ConvertFunction,
BlockLoaderExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FromAggregateMetricDouble", FromAggregateMetricDouble::new);
    private final Expression field;
    private final Expression subfieldIndex;

    @FunctionInfo(returnType={"long", "double"}, description="Convert aggregate double metric to a block of a single subfield.")
    public FromAggregateMetricDouble(Source source, @Param(name="aggregate_metric_double", type={"aggregate_metric_double", "int", "double", "long"}, description="Aggregate double metric to convert.") Expression field, @Param(name="subfieldIndex", type={"int"}, description="Index of subfield") Expression subfieldIndex) {
        super(source, List.of(field, subfieldIndex));
        this.field = field;
        this.subfieldIndex = subfieldIndex;
    }

    public static FromAggregateMetricDouble withMetric(Source source, Expression field, AggregateMetricDoubleBlockBuilder.Metric metric) {
        return new FromAggregateMetricDouble(source, field, new Literal(source, metric.getIndex(), DataType.INTEGER));
    }

    private FromAggregateMetricDouble(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.subfieldIndex);
    }

    public String getWriteableName() {
        return FromAggregateMetricDouble.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        if (!this.subfieldIndex.foldable()) {
            throw new EsqlIllegalArgumentException("Received a non-foldable value for subfield index");
        }
        Object folded = this.subfieldIndex.fold(FoldContext.small());
        if (folded == null) {
            return DataType.NULL;
        }
        int subfield = ((Number)folded).intValue();
        if (subfield == AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex()) {
            return DataType.INTEGER;
        }
        return DataType.DOUBLE;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new FromAggregateMetricDouble(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, FromAggregateMetricDouble::new, this.field, this.subfieldIndex);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType(this.field, dt -> dt == DataType.AGGREGATE_METRIC_DOUBLE, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "aggregate_metric_double only");
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public String toString() {
                return "FromAggregateMetricDoubleEvaluator[field=" + String.valueOf(fieldEvaluator) + ",subfieldIndex=" + String.valueOf(FromAggregateMetricDouble.this.subfieldIndex) + "]";
            }

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                EvalOperator.ExpressionEvaluator eval = fieldEvaluator.get(context);
                int subFieldIndex = ((Number)FromAggregateMetricDouble.this.subfieldIndex.fold(FoldContext.small())).intValue();
                return new Evaluator(context.blockFactory(), eval, subFieldIndex);
            }
        };
    }

    @Override
    public Expression field() {
        return this.field;
    }

    @Override
    public Set<DataType> supportedTypes() {
        return Set.of(DataType.AGGREGATE_METRIC_DOUBLE, DataType.INTEGER, DataType.LONG, DataType.DOUBLE);
    }

    @Override
    public BlockLoaderExpression.PushedBlockLoaderExpression tryPushToFieldLoading(SearchStats stats) {
        FieldAttribute f;
        Expression expression = this.field();
        if (expression instanceof FieldAttribute && (f = (FieldAttribute)expression).dataType() == DataType.AGGREGATE_METRIC_DOUBLE && !(f.field() instanceof MultiTypeEsField)) {
            Object folded = this.subfieldIndex.fold(FoldContext.small());
            if (folded == null) {
                throw new IllegalArgumentException("Subfield Index was null");
            }
            int subfield = ((Number)folded).intValue();
            AggregateMetricDoubleBlockBuilder.Metric metric = AggregateMetricDoubleBlockBuilder.Metric.indexToMetric((int)subfield);
            int n = 0;
            BlockLoaderFunctionConfig.Function functionConfig = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MIN", "MAX", "SUM", "COUNT", "DEFAULT"}, (AggregateMetricDoubleBlockBuilder.Metric)metric, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> BlockLoaderFunctionConfig.Function.AMD_MIN;
                case 1 -> BlockLoaderFunctionConfig.Function.AMD_MAX;
                case 2 -> BlockLoaderFunctionConfig.Function.AMD_SUM;
                case 3 -> BlockLoaderFunctionConfig.Function.AMD_COUNT;
                case 4 -> BlockLoaderFunctionConfig.Function.AMD_DEFAULT;
                case -1 -> throw new IllegalArgumentException("Received invalid subfield index [" + subfield + "].");
            };
            return new BlockLoaderExpression.PushedBlockLoaderExpression(f, (BlockLoaderFunctionConfig)new BlockLoaderFunctionConfig.JustFunction(functionConfig));
        }
        return null;
    }

    private record Evaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval, int subFieldIndex) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Evaluator.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Block eval(Page page) {
            try (Block block = this.eval.eval(page);){
                if (block.areAllValuesNull()) {
                    Block block2 = this.blockFactory.newConstantNullBlock(block.getPositionCount());
                    return block2;
                }
                Block resultBlock = ((AggregateMetricDoubleBlock)block).getMetricBlock(this.subFieldIndex);
                resultBlock.incRef();
                Block block3 = resultBlock;
                return block3;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        @Override
        public String toString() {
            return "FromAggregateMetricDoubleEvaluator[field=" + String.valueOf(this.eval) + ",subfieldIndex=" + this.subFieldIndex + "]";
        }
    }
}

