/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMaxBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMaxBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMaxDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMaxIntegerEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMaxLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class ClampMax
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ClampMax", ClampMax::new);
    private DataType resolvedType;

    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long", "double", "keyword", "ip", "boolean", "date", "version"}, description="Limits (or clamps) all input sample values to an upper bound of max. Any value above max is reduced to max.", examples={@Example(file="k8s-timeseries-clamp", tag="clamp-max")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")})
    public ClampMax(Source source, @Param(name="field", type={"double", "integer", "long", "unsigned_long", "double", "keyword", "ip", "boolean", "date", "version"}, description="field to clamp.") Expression field, @Param(name="max", type={"double", "integer", "long", "unsigned_long", "double", "keyword", "ip", "boolean", "date", "version"}, description="The max value to clamp data into.") Expression max) {
        super(source, List.of(field, max));
    }

    private ClampMax(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteable((NamedWriteable)this.children().get(1));
    }

    public String getWriteableName() {
        return ClampMax.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        if (this.resolvedType == null && !this.resolveType().resolved()) {
            throw new EsqlIllegalArgumentException("Unable to resolve data type for clamp_max");
        }
        return this.resolvedType;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression field = (Expression)this.children().get(0);
        Expression max = (Expression)this.children().get(1);
        DataType fieldDataType = field.dataType().noText();
        Expression.TypeResolution resolution = TypeResolutions.isType(field, t -> t.isNumeric() || t == DataType.BOOLEAN || t.isDate() || DataType.isString(t) || t == DataType.IP || t == DataType.VERSION, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, fieldDataType.typeName());
        if (resolution.unresolved()) {
            return resolution;
        }
        if (fieldDataType == DataType.NULL) {
            return new Expression.TypeResolution("'field' must not be null in clamp()");
        }
        resolution = TypeResolutions.isType(max, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType.noText(), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, fieldDataType.typeName());
        if (resolution.unresolved()) {
            return resolution;
        }
        this.resolvedType = !fieldDataType.isNumeric() ? fieldDataType : (fieldDataType.estimatedSize() == max.dataType().estimatedSize() ? (fieldDataType.isRationalNumber() ? fieldDataType : max.dataType()) : (fieldDataType.estimatedSize() > max.dataType().estimatedSize() ? fieldDataType : max.dataType()));
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ClampMax(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ClampMax::new, (Expression)this.children().get(0), (Expression)this.children().get(1));
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ElementType outputType = PlannerUtils.toElementType(this.dataType());
        EvalOperator.ExpressionEvaluator.Factory fieldEval = PlannerUtils.toElementType(((Expression)this.children().getFirst()).dataType()) != outputType ? Cast.cast(this.source(), ((Expression)this.children().getFirst()).dataType(), this.dataType(), toEvaluator.apply((Expression)this.children().get(0))) : toEvaluator.apply((Expression)this.children().getFirst());
        EvalOperator.ExpressionEvaluator.Factory maxEval = PlannerUtils.toElementType(((Expression)this.children().get(1)).dataType()) != outputType ? Cast.cast(this.source(), ((Expression)this.children().get(1)).dataType(), this.dataType(), toEvaluator.apply((Expression)this.children().get(1))) : toEvaluator.apply((Expression)this.children().get(1));
        return switch (outputType) {
            case ElementType.BOOLEAN -> new ClampMaxBooleanEvaluator.Factory(this.source(), fieldEval, maxEval);
            case ElementType.DOUBLE -> new ClampMaxDoubleEvaluator.Factory(this.source(), fieldEval, maxEval);
            case ElementType.INT -> new ClampMaxIntegerEvaluator.Factory(this.source(), fieldEval, maxEval);
            case ElementType.LONG -> new ClampMaxLongEvaluator.Factory(this.source(), fieldEval, maxEval);
            case ElementType.BYTES_REF -> new ClampMaxBytesRefEvaluator.Factory(this.source(), fieldEval, maxEval);
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
        };
    }

    static boolean process(boolean field, boolean max) {
        if (!max) {
            return false;
        }
        return field;
    }

    static BytesRef process(BytesRef field, BytesRef max) {
        if (field.compareTo(max) > 0) {
            return max;
        }
        return field;
    }

    static int process(int field, int max) {
        return Math.min(field, max);
    }

    static long process(long field, long max) {
        return Math.min(field, max);
    }

    static double process(double field, double max) {
        return Math.min(field, max);
    }
}

