/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.ConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.session.Configuration;

public class TBucket
extends GroupingFunction.EvaluatableGroupingFunction
implements SurrogateExpression,
TimestampAware,
ConfigurationFunction {
    public static final String NAME = "TBucket";
    private final Configuration configuration;
    private final Expression buckets;
    private final Expression timestamp;

    @FunctionInfo(returnType={"date", "date_nanos"}, description="Creates groups of values - buckets - out of a @timestamp attribute. The size of the buckets must be provided directly.", examples={@Example(description="Provide a bucket size as an argument.", file="tbucket", tag="docsTBucketByOneHourDuration", explanation="::::{note}\nWhen providing the bucket size, it must be a time duration or date period.\nAlso the reference is epoch, which starts at `0001-01-01T00:00:00Z`.\n::::"), @Example(description="Provide a string representation of bucket size as an argument.", file="tbucket", tag="docsTBucketByOneHourDurationAsString", explanation="::::{note}\nWhen providing the bucket size, it can be a string representation of time duration or date period.\nFor example, \"1 hour\". Also the reference is epoch, which starts at `0001-01-01T00:00:00Z`.\n::::")}, type=FunctionType.GROUPING)
    public TBucket(Source source, @Param(name="buckets", type={"date_period", "time_duration"}, description="Desired bucket size.") Expression buckets, Expression timestamp, Configuration configuration) {
        super(source, List.of(buckets, timestamp));
        this.buckets = buckets;
        this.timestamp = timestamp;
        this.configuration = configuration;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("should be rewritten");
    }

    @Override
    public Expression surrogate() {
        return new Bucket(this.source(), this.timestamp, this.buckets, null, null, this.configuration);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType(this.buckets, DataType::isTemporalAmount, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "date_period", "time_duration").and(TypeResolutions.isType(this.timestamp, DataType::isMillisOrNanos, this.sourceText(), TypeResolutions.ParamOrdinal.IMPLICIT, "date_nanos or datetime"));
    }

    @Override
    public DataType dataType() {
        return this.timestamp.dataType();
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new TBucket(this.source(), newChildren.get(0), newChildren.get(1), this.configuration);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, TBucket::new, this.buckets, this.timestamp, this.configuration);
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public String toString() {
        return "TBucket{buckets=" + String.valueOf(this.buckets) + "}";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.configuration);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        TBucket other = (TBucket)obj;
        return this.configuration.equals(other.configuration);
    }
}

