/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.lucene.LuceneQueryEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryExpressionEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryScoreEvaluator;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.RewriteableAware;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Kql;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Score;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.UnionAll;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.TranslationAwareExpressionQuery;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public abstract class FullTextFunction
extends org.elasticsearch.xpack.esql.core.expression.function.Function
implements TranslationAware,
PostAnalysisPlanVerificationAware,
EvaluatorMapper,
ExpressionScoreMapper,
PostOptimizationVerificationAware,
RewriteableAware,
PostOptimizationPlanVerificationAware {
    private final Expression query;
    private final QueryBuilder queryBuilder;

    protected FullTextFunction(Source source, Expression query, List<Expression> children, QueryBuilder queryBuilder) {
        super(source, children);
        this.query = query;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveParams();
    }

    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery(TypeResolutions.ParamOrdinal.DEFAULT);
    }

    protected Expression.TypeResolution resolveQuery(TypeResolutions.ParamOrdinal queryOrdinal) {
        Expression.TypeResolution result = TypeResolutions.isString(this.query(), this.sourceText(), queryOrdinal).and(TypeResolutions.isNotNull(this.query(), this.sourceText(), queryOrdinal));
        if (result.unresolved()) {
            return result;
        }
        result = Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.query()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression query() {
        return this.query;
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public String functionType() {
        return "function";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, System.identityHashCode(this.queryBuilder));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FullTextFunction other = (FullTextFunction)obj;
        return this.queryBuilder == other.queryBuilder && Objects.equals(this.query, other.query);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return TranslationAware.Translatable.YES;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return this.queryBuilder != null ? new TranslationAwareExpressionQuery(this.source(), this.queryBuilder) : this.translate(pushdownPredicates, handler);
    }

    @Override
    public QueryBuilder queryBuilder() {
        return this.queryBuilder;
    }

    protected abstract Query translate(LucenePushdownPredicates var1, TranslatorHandler var2);

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return FullTextFunction::checkFullTextQueryFunctions;
    }

    private static void checkFullTextQueryFunctions(LogicalPlan plan, Failures failures) {
        if (plan instanceof Filter) {
            Filter f = (Filter)plan;
            FullTextFunction.checkFullTextFunctionsInFilter(f, failures, false);
        } else if (plan instanceof Aggregate) {
            Aggregate agg = (Aggregate)plan;
            FullTextFunction.checkFullTextFunctionsInAggs(agg, failures);
        } else if (plan instanceof LookupJoin) {
            LookupJoin lookupJoin = (LookupJoin)plan;
            FullTextFunction.checkFullTextQueryFunctionForCondition(plan, failures, lookupJoin.config().joinOnConditions(), true, true);
        } else {
            ArrayList scoredFTFs = new ArrayList();
            plan.forEachExpression(Score.class, scoreFunction -> {
                FullTextFunction.checkScoreFunction(plan, failures, scoreFunction);
                plan.forEachExpression(FullTextFunction.class, scoredFTFs::add);
            });
            plan.forEachExpression(FullTextFunction.class, ftf -> {
                if (!scoredFTFs.remove(ftf)) {
                    failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE and STATS commands or in EVAL within score(.) function", ftf.functionName(), ftf.functionType()));
                }
            });
        }
    }

    private static void checkFullTextFunctionsInFilter(Filter filter, Failures failures, boolean checkFullTextFunctionsAboveSubqueries) {
        Expression condition = filter.condition();
        FullTextFunction.checkFullTextQueryFunctionForCondition(filter, failures, condition, false, checkFullTextFunctionsAboveSubqueries);
    }

    private static void checkFullTextQueryFunctionForCondition(LogicalPlan plan, Failures failures, Expression condition, boolean isLookupJoinOnCondition, boolean checkFullTextFunctionsAboveSubqueries) {
        boolean checkCommandsBeforeExpression;
        if (condition == null) {
            return;
        }
        if (condition instanceof Score) {
            failures.add(Failure.fail(condition, "[SCORE] function can't be used in WHERE or LOOKUP JOIN ON conditions", new Object[0]));
        }
        boolean bl = checkCommandsBeforeExpression = isLookupJoinOnCondition || checkFullTextFunctionsAboveSubqueries || !FullTextFunction.hasSubqueryInChildrenPlans(plan);
        if (checkCommandsBeforeExpression) {
            if (!isLookupJoinOnCondition) {
                List.of(QueryString.class, Kql.class).forEach(functionClass -> FullTextFunction.checkCommandsBeforeExpression(plan, condition, functionClass, lp -> lp instanceof Filter || lp instanceof OrderBy || lp instanceof EsRelation, fullTextFunction -> "[" + fullTextFunction.functionName() + "] " + fullTextFunction.functionType(), failures));
            }
            FullTextFunction.checkCommandsBeforeExpression(plan, condition, FullTextFunction.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate) && !(lp instanceof UnionAll), m -> "[" + m.functionName() + "] " + m.functionType(), failures);
        }
        FullTextFunction.checkFullTextFunctionsParents(condition, failures);
    }

    private static void checkScoreFunction(LogicalPlan plan, Failures failures, Score scoreFunction) {
        FullTextFunction.checkCommandsBeforeExpression(plan, scoreFunction.canonical(), Score.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate), m -> "[" + m.functionName() + "] function", failures);
    }

    private static void checkFullTextFunctionsInAggs(Aggregate agg, Failures failures) {
        agg.groupings().forEach(exp -> exp.forEachDown(e -> {
            if (e instanceof FullTextFunction) {
                FullTextFunction ftf = (FullTextFunction)e;
                failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE and STATS commands", ftf.functionName(), ftf.functionType()));
            }
        }));
    }

    private static <E extends Expression> void checkCommandsBeforeExpression(LogicalPlan plan, Expression condition, Class<E> typeToken, Predicate<LogicalPlan> commandCheck, Function<E, String> typeErrorMsgProvider, Failures failures) {
        condition.forEachDown(typeToken, exp -> plan.forEachDown(LogicalPlan.class, lp -> {
            if (!commandCheck.test((LogicalPlan)lp)) {
                String sourceText = lp.sourceText();
                String errorMessage = sourceText.split(" ")[0].toUpperCase(Locale.ROOT);
                if (lp instanceof UnionAll) {
                    errorMessage = sourceText.length() > 110 ? sourceText.substring(0, 110) + "..." : sourceText;
                }
                failures.add(Failure.fail(plan, "{} cannot be used after {}", typeErrorMsgProvider.apply(exp), errorMessage));
            }
        }));
    }

    private static void checkFullTextFunctionsParents(Expression condition, Failures failures) {
        FullTextFunction.forEachFullTextFunctionParent(condition, (ftf, parent) -> {
            if (!(parent instanceof FullTextFunction || parent instanceof BinaryLogic || parent instanceof EsqlBinaryComparison || parent instanceof Not)) {
                failures.add(Failure.fail(condition, "Invalid condition [{}]. [{}] {} can't be used with {}", condition.sourceText(), ftf.functionName(), ftf.functionType(), ((org.elasticsearch.xpack.esql.core.expression.function.Function)parent).functionName()));
            }
        });
    }

    private static FullTextFunction forEachFullTextFunctionParent(Expression condition, BiConsumer<FullTextFunction, Expression> action) {
        if (condition instanceof FullTextFunction) {
            FullTextFunction ftf = (FullTextFunction)condition;
            return ftf;
        }
        for (Expression child : condition.children()) {
            FullTextFunction foundMatchingChild = FullTextFunction.forEachFullTextFunctionParent(child, action);
            if (foundMatchingChild == null) continue;
            action.accept(foundMatchingChild, condition);
            return foundMatchingChild;
        }
        return null;
    }

    protected void fieldVerifier(LogicalPlan plan, FullTextFunction function, Expression field, Failures failures) {
        Literal literal;
        if (!FullTextFunction.isInCurrentNode(plan, function) || field instanceof Literal && (literal = (Literal)field).value() == null) {
            return;
        }
        if (Expressions.isGuaranteedNull(field)) {
            return;
        }
        FieldAttribute fieldAttribute = this.fieldAsFieldAttribute(field);
        if (fieldAttribute == null) {
            plan.forEachExpression(function.getClass(), m -> {
                if (function.children().contains(field) && !FullTextFunction.hasSubqueryInChildrenPlans(plan)) {
                    failures.add(Failure.fail(field, "[{}] {} cannot operate on [{}], which is not a field from an index mapping", m.functionName(), m.functionType(), field.sourceText()));
                }
            });
        } else {
            if (plan instanceof Join && !(plan instanceof InlineJoin)) {
                return;
            }
            plan.forEachDown(p -> {
                EsRelation esRelation;
                if (p instanceof EsRelation && (esRelation = (EsRelation)p).indexMode() != IndexMode.STANDARD && esRelation.outputSet().contains(fieldAttribute)) {
                    failures.add(Failure.fail(field, "[{}] {} cannot operate on [{}], supplied by an index [{}] in non-STANDARD mode [{}]", function.functionName(), function.functionType(), field.sourceText(), esRelation.indexPattern(), esRelation.indexMode()));
                }
            });
        }
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new LuceneQueryExpressionEvaluator.Factory(this.toShardConfigs(toEvaluator.shardContexts()));
    }

    protected QueryBuilder evaluatorQueryBuilder() {
        return this.queryBuilder();
    }

    @Override
    public ScoreOperator.ExpressionScorer.Factory toScorer(ExpressionScoreMapper.ToScorer toScorer) {
        return new LuceneQueryScoreEvaluator.Factory(this.toShardConfigs(toScorer.shardContexts()));
    }

    private IndexedByShardId<LuceneQueryEvaluator.ShardConfig> toShardConfigs(IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext> contexts) {
        return contexts.map(sc -> new LuceneQueryEvaluator.ShardConfig(sc.toQuery(this.evaluatorQueryBuilder()), sc.searcher()));
    }

    protected String getNameFromFieldAttribute(FieldAttribute fieldAttribute) {
        String fieldName = fieldAttribute.name();
        EsField esField = fieldAttribute.field();
        if (esField instanceof MultiTypeEsField) {
            MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
            fieldName = multiTypeEsField.getName();
        }
        return fieldName;
    }

    protected FieldAttribute fieldAsFieldAttribute(Expression field) {
        FieldAttribute fieldAttribute;
        Expression fieldExpression = field;
        if (fieldExpression instanceof AbstractConvertFunction) {
            AbstractConvertFunction convertFunction = (AbstractConvertFunction)fieldExpression;
            fieldExpression = convertFunction.field();
        }
        return fieldExpression instanceof FieldAttribute ? (fieldAttribute = (FieldAttribute)fieldExpression) : null;
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.query(), failures));
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postOptimizationPlanVerification() {
        return (logicalPlan, failures) -> {
            if (logicalPlan instanceof Filter) {
                Filter f = (Filter)logicalPlan;
                FullTextFunction.checkFullTextFunctionsInFilter(f, failures, true);
            }
        };
    }

    private static boolean isInCurrentNode(LogicalPlan plan, FullTextFunction function) {
        Holder found = new Holder((Object)false);
        plan.forEachExpression(FullTextFunction.class, ftf -> {
            if (ftf == function) {
                found.set((Object)true);
            }
        });
        return (Boolean)found.get();
    }

    private static boolean hasSubqueryInChildrenPlans(LogicalPlan plan) {
        Holder hasSubquery = new Holder((Object)false);
        plan.forEachDown(p -> {
            if (p instanceof UnionAll) {
                hasSubquery.set((Object)true);
            }
        });
        return (Boolean)hasSubquery.get();
    }
}

