/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianShapeDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianShapeSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoShapeDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoShapeSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public final class SpatialExtent
extends SpatialAggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialExtent", SpatialExtent::new);

    @FunctionInfo(returnType={"geo_shape", "cartesian_shape"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Calculate the spatial extent over a field with geometry type. Returns a bounding box for all values of the field.", type=FunctionType.AGGREGATE, examples={@Example(file="spatial", tag="st_extent_agg-airports")})
    public SpatialExtent(Source source, @Param(name="field", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, MappedFieldType.FieldExtractPreference.NONE);
    }

    private SpatialExtent(Source source, Expression field, Expression filter, Expression window, MappedFieldType.FieldExtractPreference preference) {
        super(source, field, filter, window, preference);
    }

    private SpatialExtent(StreamInput in) throws IOException {
        super(in, MappedFieldType.FieldExtractPreference.NONE);
    }

    public String getWriteableName() {
        return SpatialExtent.ENTRY.name;
    }

    @Override
    public SpatialExtent withFilter(Expression filter) {
        return new SpatialExtent(this.source(), this.field(), filter, this.window(), this.fieldExtractPreference);
    }

    @Override
    public SpatialExtent withFieldExtractPreference(MappedFieldType.FieldExtractPreference preference) {
        return new SpatialExtent(this.source(), this.field(), this.filter(), this.window(), preference);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatial(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public DataType dataType() {
        return DataType.isSpatialGeo(this.field().dataType()) ? DataType.GEO_SHAPE : DataType.CARTESIAN_SHAPE;
    }

    @Override
    protected NodeInfo<SpatialExtent> info() {
        return NodeInfo.create(this, SpatialExtent::new, this.field());
    }

    @Override
    public SpatialExtent replaceChildren(List<Expression> newChildren) {
        return new SpatialExtent(this.source(), newChildren.get(0));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.GEO_POINT -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOC_VALUES: {
                        yield new SpatialExtentGeoPointDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case EXTRACT_SPATIAL_BOUNDS: 
                    case STORED: 
                }
                yield new SpatialExtentGeoPointSourceValuesAggregatorFunctionSupplier();
            }
            case DataType.CARTESIAN_POINT -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOC_VALUES: {
                        yield new SpatialExtentCartesianPointDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case EXTRACT_SPATIAL_BOUNDS: 
                    case STORED: 
                }
                yield new SpatialExtentCartesianPointSourceValuesAggregatorFunctionSupplier();
            }
            case DataType.GEO_SHAPE -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EXTRACT_SPATIAL_BOUNDS: {
                        yield new SpatialExtentGeoShapeDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case STORED: {
                        yield new SpatialExtentGeoShapeSourceValuesAggregatorFunctionSupplier();
                    }
                    case DOC_VALUES: 
                }
                throw new EsqlIllegalArgumentException("Illegal field extract preference: " + String.valueOf(this.fieldExtractPreference));
            }
            case DataType.CARTESIAN_SHAPE -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EXTRACT_SPATIAL_BOUNDS: {
                        yield new SpatialExtentCartesianShapeDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case STORED: {
                        yield new SpatialExtentCartesianShapeSourceValuesAggregatorFunctionSupplier();
                    }
                    case DOC_VALUES: 
                }
                throw new EsqlIllegalArgumentException("Illegal field extract preference: " + String.valueOf(this.fieldExtractPreference));
            }
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }
}

