/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.HistogramBlock;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.AggregateMetricDoubleNativeSupport;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.ExtractHistogramComponent;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Max
extends AggregateFunction
implements ToAggregator,
SurrogateExpression,
AggregateMetricDoubleNativeSupport {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Max", Max::new);
    private static final Map<DataType, Supplier<AggregatorFunctionSupplier>> SUPPLIERS = Map.ofEntries(Map.entry(DataType.BOOLEAN, MaxBooleanAggregatorFunctionSupplier::new), Map.entry(DataType.LONG, MaxLongAggregatorFunctionSupplier::new), Map.entry(DataType.UNSIGNED_LONG, MaxLongAggregatorFunctionSupplier::new), Map.entry(DataType.DATETIME, MaxLongAggregatorFunctionSupplier::new), Map.entry(DataType.DATE_NANOS, MaxLongAggregatorFunctionSupplier::new), Map.entry(DataType.INTEGER, MaxIntAggregatorFunctionSupplier::new), Map.entry(DataType.DOUBLE, MaxDoubleAggregatorFunctionSupplier::new), Map.entry(DataType.IP, MaxIpAggregatorFunctionSupplier::new), Map.entry(DataType.KEYWORD, MaxBytesRefAggregatorFunctionSupplier::new), Map.entry(DataType.TEXT, MaxBytesRefAggregatorFunctionSupplier::new), Map.entry(DataType.VERSION, MaxBytesRefAggregatorFunctionSupplier::new));

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "unsigned_long", "version"}, description="The maximum value of a field.", type=FunctionType.AGGREGATE, examples={@Example(file="stats", tag="max"), @Example(description="The expression can use inline functions. For example, to calculate the maximum over an average of a multivalued column, use `MV_AVG` to first average the multiple values per row, and use the result with the `MAX` function", file="stats", tag="docsStatsMaxNestedExpression")})
    public Max(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "text", "unsigned_long", "version", "exponential_histogram", "tdigest"}) Expression field) {
        this(source, field, Literal.TRUE, NO_WINDOW);
    }

    public Max(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private Max(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Max.ENTRY.name;
    }

    @Override
    public Max withFilter(Expression filter) {
        return new Max(this.source(), this.field(), filter, this.window());
    }

    @Override
    protected NodeInfo<Max> info() {
        return NodeInfo.create(this, Max::new, this.field(), this.filter(), this.window());
    }

    @Override
    public Max replaceChildren(List<Expression> newChildren) {
        return new Max(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> SUPPLIERS.containsKey(dt) || dt == DataType.AGGREGATE_METRIC_DOUBLE || dt == DataType.EXPONENTIAL_HISTOGRAM || dt == DataType.TDIGEST, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "boolean", "date", "ip", "string", "version", "aggregate_metric_double", "exponential_histogram", "tdigest", "numeric except counter types");
    }

    @Override
    public DataType dataType() {
        if (this.field().dataType() == DataType.AGGREGATE_METRIC_DOUBLE || this.field().dataType() == DataType.EXPONENTIAL_HISTOGRAM || this.field().dataType() == DataType.TDIGEST) {
            return DataType.DOUBLE;
        }
        return this.field().dataType().noText();
    }

    @Override
    public final AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (!SUPPLIERS.containsKey((Object)type)) {
            throw EsqlIllegalArgumentException.illegalDataType(type);
        }
        return SUPPLIERS.get((Object)type).get();
    }

    @Override
    public Expression surrogate() {
        if (this.field().dataType() == DataType.AGGREGATE_METRIC_DOUBLE) {
            return new Max(this.source(), FromAggregateMetricDouble.withMetric(this.source(), this.field(), AggregateMetricDoubleBlockBuilder.Metric.MAX), this.filter(), this.window());
        }
        if (this.field().dataType() == DataType.EXPONENTIAL_HISTOGRAM || this.field().dataType() == DataType.TDIGEST) {
            return new Max(this.source(), ExtractHistogramComponent.create(this.source(), this.field(), HistogramBlock.Component.MAX), this.filter(), this.window());
        }
        return this.field().foldable() ? new MvMax(this.source(), this.field()) : null;
    }
}

