/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.HistogramMergeExponentialHistogramAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.HistogramMergeTDigestAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class HistogramMerge
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "HistogramMerge", HistogramMerge::new);

    @FunctionInfo(returnType={"exponential_histogram", "tdigest"}, type=FunctionType.AGGREGATE)
    public HistogramMerge(Source source, @Param(name="histogram", type={"exponential_histogram", "tdigest"}) Expression field) {
        this(source, field, Literal.TRUE, NO_WINDOW);
    }

    public HistogramMerge(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private HistogramMerge(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return HistogramMerge.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> dt == DataType.EXPONENTIAL_HISTOGRAM || dt == DataType.TDIGEST, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "exponential_histogram", "tdigest");
    }

    @Override
    protected NodeInfo<HistogramMerge> info() {
        return NodeInfo.create(this, HistogramMerge::new, this.field(), this.filter(), this.window());
    }

    @Override
    public HistogramMerge replaceChildren(List<Expression> newChildren) {
        return new HistogramMerge(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public HistogramMerge withFilter(Expression filter) {
        return new HistogramMerge(this.source(), this.field(), filter, this.window());
    }

    @Override
    public final AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (type == DataType.EXPONENTIAL_HISTOGRAM) {
            return new HistogramMergeExponentialHistogramAggregatorFunctionSupplier();
        }
        if (type == DataType.TDIGEST) {
            return new HistogramMergeTDigestAggregatorFunctionSupplier();
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

