/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DerivDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DerivIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DerivLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Deriv
extends TimeSeriesAggregateFunction
implements ToAggregator,
TimestampAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Deriv", Deriv::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the derivative over time of a numeric field using linear regression.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="deriv")})
    public Deriv(Source source, @Param(name="field", type={"long", "integer", "double"}, description="the metric field to calculate the value for") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the derivative over time", optional=true) Expression window, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW), timestamp);
    }

    public Deriv(Source source, Expression field, Expression filter, Expression window, Expression timestamp) {
        super(source, field, filter, window, List.of(timestamp));
        this.timestamp = timestamp;
    }

    private Deriv(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return this;
    }

    @Override
    public AggregateFunction withFilter(Expression filter) {
        return new Deriv(this.source(), this.field(), filter, this.window(), this.timestamp);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> dt.isNumeric() && dt != DataType.AGGREGATE_METRIC_DOUBLE, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "numeric except counter types");
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Deriv(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Deriv::new, this.field(), this.filter(), this.window(), this.timestamp);
    }

    public String getWriteableName() {
        return Deriv.ENTRY.name;
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        boolean isDateNanos = this.timestamp.dataType() == DataType.DATE_NANOS;
        return switch (type) {
            case DataType.DOUBLE -> new DerivDoubleAggregatorFunctionSupplier(isDateNanos);
            case DataType.LONG -> new DerivLongAggregatorFunctionSupplier(isDateNanos);
            case DataType.INTEGER -> new DerivIntAggregatorFunctionSupplier(isDateNanos);
            default -> throw new IllegalArgumentException("Unsupported data type for deriv aggregation: " + String.valueOf((Object)type));
        };
    }
}

