/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DeltaDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DeltaIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DeltaLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Delta
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator,
TimestampAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Delta", Delta::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the absolute change of a gauge field in a time window.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries-delta", tag="delta")})
    public Delta(Source source, @Param(name="field", type={"long", "integer", "double"}, description="the metric field to calculate the value for") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the delta over time", optional=true) Expression window, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW), timestamp);
    }

    public Delta(Source source, Expression field, Expression filter, Expression window, Expression timestamp) {
        super(source, field, filter, window, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public Delta(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Delta.readWindow(in), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    public String getWriteableName() {
        return Delta.ENTRY.name;
    }

    @Override
    protected NodeInfo<Delta> info() {
        return NodeInfo.create(this, Delta::new, this.field(), this.filter(), this.window(), this.timestamp);
    }

    @Override
    public Delta replaceChildren(List<Expression> newChildren) {
        return new Delta(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Delta withFilter(Expression filter) {
        return new Delta(this.source(), this.field(), filter, this.window(), this.timestamp);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> dt.isNumeric() && dt != DataType.AGGREGATE_METRIC_DOUBLE, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "numeric except counter types");
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.LONG -> new DeltaLongAggregatorFunctionSupplier();
            case DataType.INTEGER -> new DeltaIntAggregatorFunctionSupplier();
            case DataType.DOUBLE -> new DeltaDoubleAggregatorFunctionSupplier();
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public Delta perTimeSeriesAggregation() {
        return this;
    }

    @Override
    public String toString() {
        return "delta(" + String.valueOf(this.field()) + ", " + String.valueOf(this.timestamp()) + ")";
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }
}

