/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.AggregateMetricDoubleNativeSupport;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Absent;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class AbsentOverTime
extends TimeSeriesAggregateFunction
implements AggregateMetricDoubleNativeSupport {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "AbsentOverTime", AbsentOverTime::new);

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"boolean"}, description="Calculates the absence of a field in the output result over time range.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="absent_over_time")})
    public AbsentOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "histogram", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version", "exponential_histogram", "tdigest"}, description="the metric field to calculate the value for") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the absent over time", optional=true) Expression window) {
        this(source, field, Literal.TRUE, Objects.requireNonNullElse(window, NO_WINDOW));
    }

    public AbsentOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, List.of());
    }

    private AbsentOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return AbsentOverTime.ENTRY.name;
    }

    @Override
    public AbsentOverTime withFilter(Expression filter) {
        return new AbsentOverTime(this.source(), this.field(), filter, this.window());
    }

    @Override
    protected NodeInfo<AbsentOverTime> info() {
        return NodeInfo.create(this, AbsentOverTime::new, this.field(), this.filter(), this.window());
    }

    @Override
    public AbsentOverTime replaceChildren(List<Expression> newChildren) {
        return new AbsentOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    @Override
    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Absent perTimeSeriesAggregation() {
        return new Absent(this.source(), this.field(), this.filter(), this.window());
    }
}

