/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.UnresolvedException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedNamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;

public class UnresolvedNamePattern
extends UnresolvedNamedExpression {
    private final CharacterRunAutomaton automaton;
    private final String pattern;
    private final String name;

    public UnresolvedNamePattern(Source source, CharacterRunAutomaton automaton, String patternString, String name) {
        super(source, Collections.emptyList());
        this.automaton = automaton;
        this.pattern = patternString;
        this.name = name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public boolean match(String string) {
        return this.automaton.run(string);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String pattern() {
        return this.pattern;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    protected NodeInfo<UnresolvedNamePattern> info() {
        return NodeInfo.create(this, UnresolvedNamePattern::new, this.automaton, this.pattern, this.name);
    }

    @Override
    public String unresolvedMessage() {
        return "Unresolved pattern [" + this.pattern + "]";
    }

    public static String errorMessage(String pattern, List<String> potentialMatches) {
        String msg = "No matches found for pattern [" + pattern + "]";
        if (!CollectionUtils.isEmpty(potentialMatches)) {
            msg = msg + ", did you mean to match " + (potentialMatches.size() == 1 ? "[" + potentialMatches.get(0) + "]" : "any of " + String.valueOf(potentialMatches)) + "?";
        }
        return msg;
    }

    @Override
    public Nullability nullable() {
        throw new UnresolvedException("nullable", this);
    }

    @Override
    protected int innerHashCode(boolean ignoreIds) {
        return Objects.hash(super.innerHashCode(true), this.pattern);
    }

    @Override
    protected boolean innerEquals(Object o, boolean ignoreIds) {
        UnresolvedNamePattern other = (UnresolvedNamePattern)o;
        return super.innerEquals(other, true) && Objects.equals(this.pattern, other.pattern);
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "?" + this.pattern;
    }
}

