/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Order
extends Expression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Order", Order::new);
    private final Expression child;
    private final OrderDirection direction;
    private final NullsPosition nulls;

    public Order(Source source, Expression child, OrderDirection direction, NullsPosition nulls) {
        super(source, List.of(child));
        this.child = child;
        this.direction = direction;
        this.nulls = nulls == null ? NullsPosition.ANY : nulls;
    }

    public Order(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (OrderDirection)in.readEnum(OrderDirection.class), (NullsPosition)in.readEnum(NullsPosition.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child);
        out.writeEnum((Enum)this.direction);
        out.writeEnum((Enum)this.nulls);
    }

    public String getWriteableName() {
        return Order.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (DataType.isString(this.child.dataType())) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isExact(this.child, "ORDER BY cannot be applied to field of data type [{}]: {}");
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Order replaceChildren(List<Expression> newChildren) {
        return new Order(this.source(), newChildren.get(0), this.direction, this.nulls);
    }

    @Override
    protected NodeInfo<Order> info() {
        return NodeInfo.create(this, Order::new, this.child, this.direction, this.nulls);
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public Expression child() {
        return this.child;
    }

    public OrderDirection direction() {
        return this.direction;
    }

    public NullsPosition nullsPosition() {
        return this.nulls;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.child, this.direction, this.nulls});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals((Object)this.nulls, (Object)other.nulls) && Objects.equals(this.child, other.child);
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }

    public static enum NullsPosition {
        FIRST,
        LAST,
        ANY;

    }
}

