/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.util.Locale;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;

public class EsqlTypeResolutions {
    private static final String[] SPATIAL_TYPE_NAMES = new String[]{DataType.GEO_POINT.typeName(), DataType.CARTESIAN_POINT.typeName(), DataType.GEO_SHAPE.typeName(), DataType.CARTESIAN_SHAPE.typeName()};
    private static final String[] SPATIAL_AND_GRID_TYPE_NAMES = new String[]{DataType.GEO_POINT.typeName(), DataType.CARTESIAN_POINT.typeName(), DataType.GEO_SHAPE.typeName(), DataType.CARTESIAN_SHAPE.typeName(), DataType.GEOHASH.typeName(), DataType.GEOTILE.typeName(), DataType.GEOHEX.typeName()};
    private static final String[] POINT_TYPE_NAMES = new String[]{DataType.GEO_POINT.typeName(), DataType.CARTESIAN_POINT.typeName()};

    public static Expression.TypeResolution isStringAndExact(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        Expression.TypeResolution resolution = TypeResolutions.isString(e, operationName, paramOrd);
        if (resolution.unresolved()) {
            return resolution;
        }
        return EsqlTypeResolutions.isExact(e, operationName, paramOrd);
    }

    public static Expression.TypeResolution isExact(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        if (e instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)e;
            if (DataType.isString(fa.dataType())) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            EsField.Exact exact = fa.getExactInfo();
            if (!exact.hasExact()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] cannot operate on {}field of data type [{}]: {}", (Object[])new Object[]{operationName, paramOrd == null || paramOrd == TypeResolutions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " argument ", e.dataType().typeName(), exact.errorMsg()}));
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isSpatialPoint(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isSpatialPoint, operationName, paramOrd, POINT_TYPE_NAMES);
    }

    public static Expression.TypeResolution isSpatial(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isSpatial, operationName, paramOrd, SPATIAL_TYPE_NAMES);
    }

    public static Expression.TypeResolution isSpatialOrGrid(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isSpatialOrGrid, operationName, paramOrd, SPATIAL_AND_GRID_TYPE_NAMES);
    }
}

