/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.mapper;

import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;

public interface EvaluatorMapper {
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(ToEvaluator var1);

    default public Object fold(Source source, final FoldContext ctx) {
        ToEvaluator foldChildren = new ToEvaluator(){

            @Override
            public EvalOperator.ExpressionEvaluator.Factory apply(final Expression expression) {
                return driverContext -> new EvalOperator.ExpressionEvaluator(){

                    public Block eval(Page page) {
                        return BlockUtils.fromArrayRow((BlockFactory)driverContext.blockFactory(), (Object[])new Object[]{expression.fold(ctx)})[0];
                    }

                    public long baseRamBytesUsed() {
                        throw new UnsupportedOperationException("no used");
                    }

                    public void close() {
                    }
                };
            }

            @Override
            public FoldContext foldCtx() {
                return ctx;
            }
        };
        final CircuitBreaker breaker = ctx.circuitBreakerView(source);
        BigArrays bigArrays = new BigArrays(null, new CircuitBreakerService(this){

            public CircuitBreaker getBreaker(String name) {
                if (!name.equals("request")) {
                    throw new UnsupportedOperationException();
                }
                return breaker;
            }

            public AllCircuitBreakerStats stats() {
                throw new UnsupportedOperationException();
            }

            public CircuitBreakerStats stats(String name) {
                throw new UnsupportedOperationException();
            }
        }, "request").withCircuitBreaking();
        DriverContext driverCtx = new DriverContext(bigArrays, new BlockFactory(breaker, bigArrays));
        Block block = this.toEvaluator(foldChildren).get(driverCtx).eval(new Page(1, new Block[0]));
        if (block.getPositionCount() != 1) {
            throw new IllegalStateException("generated odd block from fold [" + String.valueOf(block) + "]");
        }
        return BlockUtils.toJavaObject((Block)block, (int)0);
    }

    public static interface ToEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Expression var1);

        public FoldContext foldCtx();

        default public IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext> shardContexts() {
            throw new UnsupportedOperationException("Shard contexts should only be needed for evaluation operations");
        }
    }
}

