/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;

public class FunctionEsField
extends EsField {
    private final transient BlockLoaderFunctionConfig functionConfig;

    public FunctionEsField(EsField esField, DataType dataType, BlockLoaderFunctionConfig functionConfig) {
        this(esField.getName(), dataType, esField.getProperties(), esField.isAggregatable(), esField.isAlias(), esField.getTimeSeriesFieldType(), functionConfig);
    }

    private FunctionEsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable, boolean isAlias, EsField.TimeSeriesFieldType timeSeriesFieldType, BlockLoaderFunctionConfig functionConfig) {
        super(name, esDataType, properties, aggregatable, isAlias, timeSeriesFieldType);
        this.functionConfig = functionConfig;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("FunctionEsField is not serializable, should be created on data nodes");
    }

    public BlockLoaderFunctionConfig functionConfig() {
        return this.functionConfig;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionEsField that = (FunctionEsField)o;
        return Objects.equals(this.functionConfig, that.functionConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.functionConfig);
    }

    @Override
    public EsField.Exact getExactInfo() {
        return new EsField.Exact(false, "merged with " + String.valueOf(this.functionConfig.function()));
    }
}

