/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.StringPattern;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public abstract class RegexMatch<T extends StringPattern>
extends UnaryScalarFunction {
    private final T pattern;
    private final boolean caseInsensitive;

    protected RegexMatch(Source source, Expression value, T pattern, boolean caseInsensitive) {
        super(source, value);
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
    }

    public T pattern() {
        return this.pattern;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        if (this.pattern() == null) {
            return Nullability.TRUE;
        }
        return this.field().nullable();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isStringAndExact(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Boolean fold(FoldContext ctx) {
        throw new UnsupportedOperationException();
    }

    public abstract Expression optimizeStringCasingWithInsensitiveRegexMatch(Expression var1, Predicate<String> var2);

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            RegexMatch other = (RegexMatch)obj;
            return this.caseInsensitive == other.caseInsensitive && Objects.equals(this.pattern, other.pattern);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern(), this.caseInsensitive);
    }
}

