/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class ReferenceAttribute
extends TypedAttribute {
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "ReferenceAttribute", ReferenceAttribute::readFrom);
    private static final TransportVersion ESQL_QUALIFIERS_IN_ATTRIBUTES = TransportVersion.fromName((String)"esql_qualifiers_in_attributes");

    @Deprecated
    public ReferenceAttribute(Source source, String name, DataType dataType) {
        this(source, null, name, dataType, Nullability.FALSE, null, false);
    }

    public ReferenceAttribute(Source source, @Nullable String qualifier, String name, DataType dataType) {
        this(source, qualifier, name, dataType, Nullability.FALSE, null, false);
    }

    public ReferenceAttribute(Source source, @Nullable String qualifier, String name, DataType dataType, Nullability nullability, @Nullable NameId id, boolean synthetic) {
        super(source, qualifier, name, dataType, nullability, id, synthetic);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader(this)) {
            Source.EMPTY.writeTo(out);
            out.writeString(this.name());
            this.dataType().writeTo(out);
            this.checkAndSerializeQualifier((PlanStreamOutput)out, out.getTransportVersion());
            if (!out.getTransportVersion().supports(ESQL_QUALIFIERS_IN_ATTRIBUTES)) {
                out.writeOptionalString(null);
            }
            out.writeEnum((Enum)this.nullable());
            this.id().writeTo(out);
            out.writeBoolean(this.synthetic());
        }
    }

    public static ReferenceAttribute readFrom(StreamInput in) throws IOException {
        return (ReferenceAttribute)((PlanStreamInput)in).readAttributeWithCache(ReferenceAttribute::innerReadFrom);
    }

    private static ReferenceAttribute innerReadFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        String name = in.readString();
        DataType dataType = DataType.readFrom(in);
        String qualifier = ReferenceAttribute.readQualifier((PlanStreamInput)in, in.getTransportVersion());
        if (!in.getTransportVersion().supports(ESQL_QUALIFIERS_IN_ATTRIBUTES)) {
            in.readOptionalString();
        }
        Nullability nullability = (Nullability)in.readEnum(Nullability.class);
        NameId id = NameId.readFrom((StreamInput)((PlanStreamInput)in));
        boolean synthetic = in.readBoolean();
        return new ReferenceAttribute(source, qualifier, name, dataType, nullability, id, synthetic);
    }

    public String getWriteableName() {
        return ReferenceAttribute.ENTRY.name;
    }

    @Override
    protected Attribute clone(Source source, String qualifier, String name, DataType dataType, Nullability nullability, NameId id, boolean synthetic) {
        return new ReferenceAttribute(source, qualifier, name, dataType, nullability, id, synthetic);
    }

    @Override
    protected NodeInfo<ReferenceAttribute> info() {
        return NodeInfo.create(this, ReferenceAttribute::new, this.qualifier(), this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected String label() {
        return "r";
    }

    @Override
    public boolean isDimension() {
        return false;
    }

    @Override
    public boolean isMetric() {
        return false;
    }
}

